/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import java.util.EnumSet;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GearBoxBlockEntity
extends TFCBlockEntity
implements RotatingBlockEntity {
    private final Node node;
    private boolean invalid;

    public GearBoxBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.GEAR_BOX.get(), pos, state);
    }

    public GearBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!((Boolean)state.getValue((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue()) continue;
            connections.add(direction);
        }
        this.invalid = false;
        this.node = new Node(this, pos, connections){

            @Override
            public Rotation rotation(Rotation sourceRotation, Direction sourceDirection, Direction exitDirection) {
                if (sourceDirection.getAxis() == exitDirection.getAxis()) {
                    return Rotation.of(sourceRotation, sourceRotation.direction().getOpposite());
                }
                Direction outputDirection = sourceDirection == sourceRotation.direction() ? exitDirection.getOpposite() : exitDirection;
                return Rotation.of(sourceRotation, outputDirection);
            }

            @Override
            public String toString() {
                return "GearBox[pos=%s, connections=%s, source=%s]".formatted(this.pos(), this.connections(), this.source());
            }
        };
    }

    public void updateDirection(Direction direction, boolean value) {
        assert (this.level != null);
        if (value) {
            this.node.connections().add(direction);
        } else {
            this.node.connections().remove(direction);
        }
        this.performNetworkAction(NetworkAction.UPDATE);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("invalid", this.invalid);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.invalid = tag.getBoolean("invalid");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }
}

