/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities.rotation;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotatingBlockEntity;
import net.dries007.tfc.common.blocks.rotation.AxleBlock;
import net.dries007.tfc.common.blocks.rotation.WindmillBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.Rotation;
import net.dries007.tfc.util.rotation.SourceNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class WindmillBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler>
implements RotatingBlockEntity {
    public static final int SLOTS = 5;
    public static final float MIN_SPEED = 0.015707964f;
    public static final float MAX_SPEED = 0.023561945f;
    private static final float LERP_SPEED = 1.5707964E-4f;
    private final SourceNode node;
    private boolean invalid;
    private boolean needsStateUpdate = true;
    private boolean obstructed = false;

    public static void serverTick(Level level, BlockPos pos, BlockState state, WindmillBlockEntity windmill) {
        boolean obstructedNow;
        windmill.checkForLastTickSync();
        if (windmill.needsStateUpdate) {
            windmill.updateState();
        }
        WindmillBlockEntity.clientTick(level, pos, state, windmill);
        if (level.getGameTime() % 40L == 0L && (obstructedNow = WindmillBlockEntity.isObstructedBySolidBlocks(level, pos, (Direction.Axis)state.getValue(WindmillBlock.AXIS))) != windmill.obstructed) {
            windmill.obstructed = obstructedNow;
            windmill.markForSync();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, WindmillBlockEntity windmill) {
        Rotation.Tickable rotation = windmill.node.rotation();
        if (windmill.obstructed) {
            rotation.setSpeed(0.0f);
        } else {
            rotation.tick();
            float targetBeforeWind = Mth.map((float)((Integer)state.getValue((Property)WindmillBlock.COUNT)).intValue(), (float)1.0f, (float)5.0f, (float)0.0f, (float)0.023561945f) + ((Integer)state.getValue((Property)WindmillBlock.COUNT) > 1 ? 0.015707964f : 0.0f);
            float wind = Climate.get(level).getWind(level, pos).length();
            float windFactor = Math.min(wind, 0.5f) * 4.0f;
            float targetSpeed = windFactor * targetBeforeWind;
            float currentSpeed = rotation.speed();
            float nextSpeed = targetSpeed > currentSpeed ? Math.min(targetSpeed, currentSpeed + 1.5707964E-4f) : Math.max(targetSpeed, currentSpeed - 1.5707964E-4f);
            rotation.setSpeed(nextSpeed);
        }
    }

    public boolean isObstructed() {
        return this.obstructed;
    }

    public static boolean isObstructedBySolidBlocks(Level level, BlockPos pos, Direction.Axis axis) {
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int dH = -6; dH <= 6; ++dH) {
            for (int dy = -6; dy <= 6; ++dy) {
                if (dH * dH + dy * dy >= 49 || dH == 0 && dy == 0) continue;
                cursor.setWithOffset((Vec3i)pos, axis == Direction.Axis.X ? 0 : dH, dy, axis == Direction.Axis.Z ? 0 : dH);
                BlockState state = level.getBlockState((BlockPos)cursor);
                if (state.isAir() || state.getCollisionShape((BlockGetter)level, (BlockPos)cursor).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public WindmillBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<?>)((BlockEntityType)TFCBlockEntities.WINDMILL.get()), pos, state, WindmillBlockEntity.defaultInventory(5));
    }

    public WindmillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, InventoryBlockEntity.InventoryFactory<ItemStackHandler> inventory) {
        super(type, pos, state, inventory);
        final Direction.Axis axis = (Direction.Axis)state.getValue(WindmillBlock.AXIS);
        this.invalid = false;
        this.node = new SourceNode(this, pos, Node.ofAxis(axis), Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE), 0.0f){

            @Override
            public String toString() {
                return "Windmill[pos=%s, axis=%s]".formatted(this.pos(), axis);
            }
        };
    }

    public int updateState() {
        assert (this.level != null);
        this.needsStateUpdate = false;
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        if (count == 0) {
            AxleBlock axle = ((WindmillBlock)this.getBlockState().getBlock()).getAxle();
            BlockState axleState = (BlockState)axle.defaultBlockState().setValue((Property)AxleBlock.AXIS, (Comparable)((Direction.Axis)this.getBlockState().getValue(WindmillBlock.AXIS)));
            this.level.setBlockAndUpdate(this.worldPosition, axleState);
        } else {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)WindmillBlock.COUNT, (Comparable)Integer.valueOf(count)));
        }
        return count;
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.needsStateUpdate = true;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.WINDMILL_BLADES);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.node.rotation().saveToTag(tag);
        tag.putBoolean("invalid", this.invalid);
        tag.putBoolean("obstructed", this.obstructed);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.node.rotation().loadFromTag(tag);
        this.invalid = tag.getBoolean("invalid");
        this.obstructed = tag.getBoolean("obstructed");
    }

    @Override
    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD_SOURCE);
    }

    @Override
    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    @Override
    public void markAsInvalidInNetwork() {
        this.invalid = true;
    }

    @Override
    public boolean isInvalidInNetwork() {
        return this.invalid;
    }

    @Override
    public Node getRotationNode() {
        return this.node;
    }
}

