/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BowlBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTrait;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.food.IFood;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.component.glass.GlassOperations;
import net.dries007.tfc.common.component.glass.GlassWorking;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BowlBlock
extends DeviceBlock {
    public static final VoxelShape SHAPE = BowlBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);

    public BowlBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        @Nullable BowlBlockEntity bowl = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BOWL.get()).orElse(null);
        if (bowl != null) {
            IFood food;
            Object inventory = bowl.getInventory();
            ItemStack held = player.getItemInHand(hand);
            ItemStack current = inventory.getStackInSlot(0);
            GlassOperations data = GlassWorking.get(held);
            if (!data.isEmpty()) {
                GlassOperation op = GlassOperation.getByPowder(current);
                if (op != null) {
                    GlassWorking.apply(held, op);
                    inventory.getStackInSlot(0).shrink(1);
                    Helpers.playSound(level, pos, SoundEvents.SAND_PLACE);
                    player.getCooldowns().addCooldown(held.getItem(), 10);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (held.isEmpty() && hand == InteractionHand.MAIN_HAND) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inventory.extractItem(0, player.isShiftKeyDown() ? 16 : 1, false));
                Helpers.playSound(level, pos, SoundEvents.SAND_PLACE);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (Helpers.isItem(held, TFCTags.Items.BOWL_POWDERS)) {
                player.setItemInHand(hand, Helpers.insertAllSlots(inventory, held));
                Helpers.playSound(level, pos, SoundEvents.SAND_PLACE);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (Helpers.isItem(held, TFCTags.Items.CAN_BE_SALTED) && Helpers.isItem(current, (ItemLike)TFCItems.POWDERS.get((Object)Powder.SALT).get()) && (food = FoodCapability.get(held)) != null && !food.hasTrait((Holder<FoodTrait>)FoodTraits.SALTED)) {
                int toSalt = Math.min(held.getCount(), current.getCount());
                ItemStack salted = held.split(toSalt);
                FoodCapability.applyTrait(salted, FoodTraits.SALTED);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)salted);
                inventory.getStackInSlot(0).shrink(toSalt);
                Helpers.playSound(level, pos, SoundEvents.SAND_PLACE);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

