/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.extensions.IBlockExtension;
import org.jetbrains.annotations.Nullable;

public interface IForgeBlockExtension
extends IBlockExtension {
    public ExtendedProperties getExtendedProperties();

    default public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getExtendedProperties().getFlammability();
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return this.getExtendedProperties().getFireSpreadSpeed();
    }

    @Nullable
    default public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob entity) {
        PathType type = this.getExtendedProperties().getPathType();
        return type != null ? type : super.getBlockPathType(state, level, pos, entity);
    }

    default public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return this.getExtendedProperties().getEnchantmentPower(state);
    }

    default public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getExtendedProperties().getCloneItemStack(state.getBlock());
    }

    public static <T extends Block> MapCodec<T> getFakeBlockCodec() {
        return Block.CODEC;
    }

    default public <T extends Block> MapCodec<T> fakeBlockCodec() {
        return IForgeBlockExtension.getFakeBlockCodec();
    }
}

