/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class IcicleBlock
extends ThinSpikeBlock {
    public static void spawnDripParticle(Level level, BlockPos pos, BlockState state) {
        Vec3 offset = state.getOffset((BlockGetter)level, pos);
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_DRIPSTONE_WATER, (double)pos.getX() + 0.5 + offset.x, (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625, (double)pos.getZ() + 0.5 + offset.z, 0.0, 0.0, 0.0);
    }

    public IcicleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (Helpers.isItem(player.getMainHandItem(), TFCTags.Items.TOOLS_HAMMER) || Helpers.isItem(player.getMainHandItem(), (TagKey<Item>)ItemTags.SWORDS)) {
            level.destroyBlock(pos, true);
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.offset(-2, -2, -2), (BlockPos)pos.offset(2, 2, 2))) {
                if (!(level.getBlockState(testPos).getBlock() instanceof IcicleBlock)) continue;
                level.destroyBlock(testPos, true);
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        float temperature = Climate.getTemperature(level, pos);
        if (((Boolean)state.getValue((Property)TIP)).booleanValue() && ((FluidProperty.FluidKey)state.getValue((Property)FLUID)).getFluid() == Fluids.EMPTY && temperature > 0.0f && random.nextFloat() < 0.15f && random.nextFloat() < 0.15f) {
            IcicleBlock.spawnDripParticle(level, pos, state);
        }
    }
}

