/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends PlacedItemBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final VoxelShape TOP_SHAPE = ShelfBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape TOP_SHAPE_TALL = ShelfBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ShelfBlock(ExtendedProperties properties, boolean thick) {
        super(properties, thick ? TOP_SHAPE_TALL : TOP_SHAPE, true);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        PlacedItemBlockEntity placedItem;
        BlockState toPlace;
        BlockPos above;
        boolean hitIsOnLowerHalf;
        boolean bl = hitIsOnLowerHalf = hitResult.getLocation().y() - (double)hitResult.getBlockPos().getY() < 0.5;
        if (!hitIsOnLowerHalf && hitResult.getDirection() == Direction.UP && level.isEmptyBlock(above = pos.above()) && !PlacedItemBlock.isEmptyContents(toPlace = PlacedItemBlock.updateStateValues((LevelAccessor)level, pos, ((Block)TFCBlocks.PLACED_ITEM.get()).defaultBlockState()))) {
            level.setBlockAndUpdate(above, toPlace);
            level.getBlockEntity(above, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(e -> e.insertItem(player, stack, hitResult));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (hitIsOnLowerHalf && (placedItem = (PlacedItemBlockEntity)level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.SHELF.get()).orElse(null)) != null && placedItem.onRightClick(player, player.getItemInHand(hand), hitResult)) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}));
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return TOP_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos facePos = pos.relative(facing);
        BlockState faceState = level.getBlockState(facePos);
        return faceState.isFaceSturdy((BlockGetter)level, facePos, facing.getOpposite());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        return this.canSurvive(state, (LevelReader)context.getLevel(), context.getClickedPos()) ? PlacedItemBlock.updateStateValues((LevelAccessor)context.getLevel(), context.getClickedPos().below(), state) : null;
    }
}

