/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class SnowPileBlock
extends SnowLayerBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static boolean canPlaceSnowPile(LevelAccessor level, BlockPos pos, BlockState state) {
        return Helpers.isBlock(state.getBlock(), TFCTags.Blocks.CAN_BE_SNOW_PILED) && ((SnowPileBlock)TFCBlocks.SNOW_PILE.get()).defaultBlockState().canSurvive((LevelReader)level, pos);
    }

    public static void placeSnowPile(LevelAccessor level, BlockPos pos, BlockState state, boolean byPlayer) {
        BlockPos posAbove = pos.above();
        BlockState aboveState = level.getBlockState(posAbove);
        BlockState savedAboveState = Helpers.isBlock(aboveState.getBlock(), TFCTags.Blocks.CAN_BE_SNOW_PILED) ? aboveState : null;
        BlockState snowPile = ((SnowPileBlock)TFCBlocks.SNOW_PILE.get()).defaultBlockState();
        level.setBlock(pos, snowPile, 18);
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(entity -> entity.setHiddenStates(state, savedAboveState, byPlayer));
        if (savedAboveState != null) {
            Helpers.removeBlock(level, posAbove, 18);
        }
        level.blockUpdated(pos, (Block)TFCBlocks.SNOW_PILE.get());
        if (savedAboveState != null) {
            level.blockUpdated(posAbove, Blocks.AIR);
        }
        BlockPos posBelow = pos.below();
        level.setBlock(posBelow, Helpers.setProperty(level.getBlockState(posBelow), SnowyDirtBlock.SNOWY, true), 2);
    }

    public static void removePileOrSnow(LevelAccessor level, BlockPos pos, BlockState state) {
        SnowPileBlock.removePileOrSnow(level, pos, state, level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).orElse(null));
    }

    public static void removePileOrSnow(LevelAccessor level, BlockPos pos, BlockState state, @Nullable PileBlockEntity snowPile) {
        int layers = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
        if (layers > 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(layers - 1)), 3);
        } else if (state.getBlock() == Blocks.SNOW) {
            level.removeBlock(pos, false);
        } else if (snowPile != null) {
            BlockPos above = pos.above();
            level.setBlock(pos, snowPile.getInternalState(), 18);
            if (snowPile.getAboveState() != null && level.isEmptyBlock(above)) {
                level.setBlock(above, snowPile.getAboveState(), 18);
            }
            snowPile.getInternalState().updateNeighbourShapes(level, pos, 2);
            level.getBlockState(above).updateNeighbourShapes(level, above, 2);
            level.blockUpdated(pos, snowPile.getInternalState().getBlock());
            if (snowPile.getAboveState() != null) {
                level.blockUpdated(above, snowPile.getAboveState().getBlock());
            }
        }
    }

    public SnowPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        @Nullable PileBlockEntity snowPile = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).orElse(null);
        super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        SnowPileBlock.removePileOrSnow((LevelAccessor)level, pos, state, snowPile);
        return true;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (context.getItemInHand().getItem() == Blocks.SNOW.asItem() && (Integer)state.getValue((Property)LAYERS) < 8) {
            if (context.replacingClickedOnBlock()) {
                return context.getClickedFace() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }
}

