/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class ClimbingCropBlock
extends DoubleCropBlock
implements IGhostBlockHandler {
    public static final BooleanProperty STICK = TFCBlockStateProperties.STICK;

    public static ClimbingCropBlock create(ExtendedProperties properties, int singleStages, int doubleStages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(singleStages + doubleStages - 1);
        return new ClimbingCropBlock(properties, singleStages - 1, singleStages + doubleStages - 1, TFCBlocks.DEAD_CROPS.get((Object)crop), TFCItems.CROP_SEEDS.get((Object)crop), crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty getAgeProperty() {
                return property;
            }
        };
    }

    protected ClimbingCropBlock(ExtendedProperties properties, int maxSingleAge, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosphorous, float potassium, Supplier<ClimateRange> climateRange) {
        super(properties, maxSingleAge, maxAge, dead, seeds, nitrogen, phosphorous, potassium, climateRange);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STICK, (Comparable)Boolean.valueOf(false))).setValue((Property)PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM)));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.getItemInHand(hand);
        BlockPos posAbove = pos.above();
        if (Helpers.isItem(heldStack.getItem(), (TagKey<Item>)Tags.Items.RODS_WOODEN) && !((Boolean)state.getValue((Property)STICK)).booleanValue() && level.isEmptyBlock(posAbove) && posAbove.getY() <= level.getMaxBuildHeight()) {
            if (!level.isClientSide()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)STICK, (Comparable)Boolean.valueOf(true)), 2);
                level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)STICK, (Comparable)Boolean.valueOf(true))).setValue((Property)PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), 3);
                if (!player.isCreative()) {
                    heldStack.shrink(1);
                }
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.CROP_STICK_ADD.get());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STICK}));
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        if (!CropHelpers.lightValid(level, pos)) {
            return 0.0f;
        }
        BlockState stateAbove = level.getBlockState(pos.above());
        return stateAbove.getBlock() == this && (Boolean)stateAbove.getValue((Property)STICK) != false && stateAbove.getValue((Property)PART) == DoubleCropBlock.Part.TOP ? 1.0f : this.maxSingleGrowth;
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        boolean hasTop = stateAbove.getBlock() == this;
        BlockState deadState = (BlockState)((BlockState)((Block)this.dead.get()).defaultBlockState().setValue((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown))).setValue((Property)STICK, (Comparable)((Boolean)state.getValue((Property)STICK)));
        if (hasTop) {
            level.setBlock(posAbove, (BlockState)deadState.setValue(DeadDoubleCropBlock.PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), 18);
        } else {
            level.destroyBlock(posAbove, false);
        }
        level.setBlockAndUpdate(pos, (BlockState)deadState.setValue(DeadDoubleCropBlock.PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM)));
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState state, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        BlockPos abovePos = pos.above();
        if (Helpers.isItem(item.getItem(), (TagKey<Item>)Tags.Items.RODS_WOODEN) && !((Boolean)state.getValue((Property)STICK)).booleanValue() && level.isEmptyBlock(abovePos) && abovePos.getY() <= level.getMaxBuildHeight()) {
            return (BlockState)state.setValue((Property)STICK, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }
}

