/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.ClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.DefaultCropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedDeadCropBlock;
import net.dries007.tfc.common.blocks.crop.FloodedWildCropBlock;
import net.dries007.tfc.common.blocks.crop.PickableClimbingCropBlock;
import net.dries007.tfc.common.blocks.crop.PickableCropBlock;
import net.dries007.tfc.common.blocks.crop.SpreadingCropBlock;
import net.dries007.tfc.common.blocks.crop.WildCropBlock;
import net.dries007.tfc.common.blocks.crop.WildDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.WildSpreadingCropBlock;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class Crop
extends Enum<Crop>
implements StringRepresentable {
    public static final /* enum */ Crop CASSAVA = new Crop(-0.5f, 0.4f, 0.2f, 6);
    public static final /* enum */ Crop GREEN_BEAN = new Crop(-0.8f, 0.5f, 0.4f, 4, 4, true);
    public static final /* enum */ Crop LENTIL = new Crop(-0.8f, 0.2f, 0.2f, 6);
    public static final /* enum */ Crop PEANUT = new Crop(-0.9f, 0.5f, 0.5f, 6);
    public static final /* enum */ Crop SOYBEAN = new Crop(-0.8f, 0.6f, 0.3f, 7);
    public static final /* enum */ Crop BARLEY = new Crop(0.75f, -0.2f, -0.2f, 8);
    public static final /* enum */ Crop OAT = new Crop(1.0f, -0.35f, -0.25f, 8);
    public static final /* enum */ Crop RYE = new Crop(1.0f, -0.2f, -0.4f, 8);
    public static final /* enum */ Crop MAIZE = new Crop(0.9f, -0.25f, -0.25f, 3, 3, false);
    public static final /* enum */ Crop WHEAT = new Crop(1.0f, -0.3f, -0.3f, 8);
    public static final /* enum */ Crop RICE = new Crop(0.4f, 0.3f, 0.3f, 8, true);
    public static final /* enum */ Crop BEET = new Crop(0.4f, 0.3f, 0.5f, 6);
    public static final /* enum */ Crop CABBAGE = new Crop(0.5f, 0.2f, 0.4f, 6);
    public static final /* enum */ Crop CARROT = new Crop(0.5f, 0.3f, 0.4f, 5);
    public static final /* enum */ Crop GARLIC = new Crop(0.4f, 0.2f, 0.5f, 5);
    public static final /* enum */ Crop ONION = new Crop(0.4f, 0.4f, 0.4f, 7);
    public static final /* enum */ Crop POTATO = new Crop(0.4f, 0.2f, 0.6f, 7);
    public static final /* enum */ Crop SQUASH = new Crop(0.25f, 0.45f, 0.5f, 8);
    public static final /* enum */ Crop TOMATO = new Crop(0.4f, 0.5f, 0.6f, 4, 4, true, null, () -> TFCItems.FOOD.get((Object)Food.TOMATO));
    public static final /* enum */ Crop RED_BELL_PEPPER = new Crop(0.3f, 0.4f, 0.5f, 7, () -> TFCItems.FOOD.get((Object)Food.GREEN_BELL_PEPPER), () -> TFCItems.FOOD.get((Object)Food.RED_BELL_PEPPER));
    public static final /* enum */ Crop YELLOW_BELL_PEPPER = new Crop(0.3f, 0.4f, 0.5f, 7, () -> TFCItems.FOOD.get((Object)Food.GREEN_BELL_PEPPER), () -> TFCItems.FOOD.get((Object)Food.YELLOW_BELL_PEPPER));
    public static final /* enum */ Crop PUMPKIN = new Crop(0.4f, 0.3f, 0.6f, 8, () -> TFCBlocks.PUMPKIN);
    public static final /* enum */ Crop MELON = new Crop(0.3f, 0.4f, 0.65f, 8, () -> TFCBlocks.MELON);
    public static final /* enum */ Crop CANOLA = new Crop(-0.3f, -0.6f, -1.0f, 6);
    public static final /* enum */ Crop RADISH = new Crop(-0.5f, -1.0f, -0.6f, 6);
    public static final /* enum */ Crop ALFALFA = new Crop(-0.8f, -0.5f, -0.6f, 6);
    public static final /* enum */ Crop JUTE = new Crop(0.6f, 0.4f, -0.4f, 3, 3, false);
    public static final /* enum */ Crop PAPYRUS = new Crop(0.6f, -0.4f, 0.4f, 3, 3, false);
    public static final /* enum */ Crop SUGARCANE = new Crop(0.5f, 0.5f, 0.5f, 4, 4, false);
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final float nitrogen;
    private final float phosphorous;
    private final float potassium;
    private final Supplier<Block> factory;
    private final Supplier<Block> deadFactory;
    private final Supplier<Block> wildFactory;
    private static final /* synthetic */ Crop[] $VALUES;

    public static Crop[] values() {
        return (Crop[])$VALUES.clone();
    }

    public static Crop valueOf(String name) {
        return Enum.valueOf(Crop.class, name);
    }

    private static ExtendedProperties doubleCrop() {
        return Crop.dead().blockEntity(TFCBlockEntities.CROP).serverTicks(CropBlockEntity::serverTickBottomPartOnly);
    }

    private static ExtendedProperties crop() {
        return Crop.dead().blockEntity(TFCBlockEntities.CROP).serverTicks(CropBlockEntity::serverTick);
    }

    private static ExtendedProperties dead() {
        return ExtendedProperties.of(MapColor.PLANT).noCollission().randomTicks().strength(0.4f).sound(SoundType.CROP).flammable(60, 30).pushReaction(PushReaction.DESTROY);
    }

    private Crop(float nitrogen, float phosphorus, float potassium, int singleBlockStages) {
        this(nitrogen, phosphorus, potassium, self -> DefaultCropBlock.create(Crop.crop(), singleBlockStages, self), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(float nitrogen, float phosphorus, float potassium, int spreadingSingleBlockStages, Supplier<Supplier<? extends Block>> fruit) {
        this(nitrogen, phosphorus, potassium, self -> SpreadingCropBlock.create(Crop.crop(), spreadingSingleBlockStages, self, fruit), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildSpreadingCropBlock(Crop.dead().randomTicks(), fruit));
    }

    private Crop(float nitrogen, float phosphorus, @Nullable float potassium, int spreadingSingleBlockStages, Supplier<Supplier<? extends Item>> fruit1, Supplier<Supplier<? extends Item>> fruit2) {
        this(nitrogen, phosphorus, potassium, self -> PickableCropBlock.create(Crop.crop(), spreadingSingleBlockStages, self, fruit1, fruit2), (Crop self) -> new DeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(float nitrogen, float phosphorus, float potassium, int floodedSingleBlockStages, boolean flooded) {
        this(nitrogen, phosphorus, potassium, self -> FloodedCropBlock.create(Crop.crop(), floodedSingleBlockStages, self), (Crop self) -> new FloodedDeadCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new FloodedWildCropBlock(Crop.dead().randomTicks()));
        assert (flooded);
    }

    private Crop(float nitrogen, float phosphorus, float potassium, int doubleBlockBottomStages, @Nullable int doubleBlockTopStages, boolean requiresStick, Supplier<Supplier<? extends Item>> fruit1, Supplier<Supplier<? extends Item>> fruit2) {
        this(nitrogen, phosphorus, potassium, requiresStick ? self -> PickableClimbingCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self, fruit1, fruit2) : self -> DoubleCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self), requiresStick ? self -> new DeadClimbingCropBlock(Crop.dead(), self.getClimateRange()) : self -> new DeadDoubleCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildDoubleCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(float nitrogen, float phosphorus, float potassium, int doubleBlockBottomStages, int doubleBlockTopStages, boolean requiresStick) {
        this(nitrogen, phosphorus, potassium, requiresStick ? self -> ClimbingCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self) : self -> DoubleCropBlock.create(Crop.doubleCrop(), doubleBlockBottomStages, doubleBlockTopStages, self), requiresStick ? self -> new DeadClimbingCropBlock(Crop.dead(), self.getClimateRange()) : self -> new DeadDoubleCropBlock(Crop.dead(), self.getClimateRange()), (Crop self) -> new WildDoubleCropBlock(Crop.dead().randomTicks()));
    }

    private Crop(float nitrogen, float phosphorus, float potassium, Function<Crop, Block> factory, Function<Crop, Block> deadFactory, Function<Crop, Block> wildFactory) {
        this.nitrogen = nitrogen;
        this.phosphorous = phosphorus;
        this.potassium = potassium;
        this.factory = () -> (Block)factory.apply(this);
        this.deadFactory = () -> (Block)deadFactory.apply(this);
        this.wildFactory = () -> (Block)wildFactory.apply(this);
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public Block create() {
        return this.factory.get();
    }

    public Block createDead() {
        return this.deadFactory.get();
    }

    public Block createWild() {
        return this.wildFactory.get();
    }

    public float getNitrogen() {
        return this.nitrogen;
    }

    public float getPhosphorous() {
        return this.phosphorous;
    }

    public float getPotassium() {
        return this.potassium;
    }

    public Supplier<ClimateRange> getClimateRange() {
        return ClimateRanges.CROPS.get((Object)this);
    }

    private static /* synthetic */ Crop[] $values() {
        return new Crop[]{CASSAVA, GREEN_BEAN, LENTIL, PEANUT, SOYBEAN, BARLEY, OAT, RYE, MAIZE, WHEAT, RICE, BEET, CABBAGE, CARROT, GARLIC, ONION, POTATO, SQUASH, TOMATO, RED_BELL_PEPPER, YELLOW_BELL_PEPPER, PUMPKIN, MELON, CANOLA, RADISH, ALFALFA, JUTE, PAPYRUS, SUGARCANE};
    }

    static {
        $VALUES = Crop.$values();
    }
}

