/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.IFarmland;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CropBlock
extends net.minecraft.world.level.block.CropBlock
implements HoeOverlayBlock,
ICropBlock,
IForgeBlockExtension,
EntityBlockExtension {
    public static final VoxelShape QUARTER_SHAPE = CropBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape HALF_SHAPE = CropBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    public static final VoxelShape FULL_SHAPE = CropBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected final float nNeeded;
    protected final float pNeeded;
    protected final float kNeeded;
    protected final Supplier<? extends Block> dead;
    protected final Supplier<? extends Item> seeds;
    protected final Supplier<ClimateRange> climateRange;
    protected final int maxAge;
    private final ExtendedProperties extendedProperties;

    protected CropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosporous, float potassium, Supplier<ClimateRange> climateRange) {
        super(properties.properties());
        this.extendedProperties = properties;
        this.maxAge = maxAge;
        this.dead = dead;
        this.seeds = seeds;
        this.nNeeded = nitrogen;
        this.pNeeded = phosporous;
        this.kNeeded = potassium;
        this.climateRange = climateRange;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.extendedProperties;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        float growth = (float)((Integer)state.getValue((Property)this.getAgeProperty())).intValue() / (float)this.getMaxAge();
        if (growth <= 0.25f) {
            return QUARTER_SHAPE;
        }
        if (growth <= 0.5f) {
            return HALF_SHAPE;
        }
        return FULL_SHAPE;
    }

    public abstract IntegerProperty getAgeProperty();

    public int getMaxAge() {
        return this.maxAge;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.tick(state, level, pos, random);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : state;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.FARMLANDS);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)this.seeds.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty()});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return CropHelpers.useFertilizer(level, player, hand, pos.below()) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide) : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isClientSide()) {
            if (this.canSurvive(state, (LevelReader)level, pos)) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof CropBlockEntity) {
                    CropBlockEntity crop = (CropBlockEntity)blockEntity;
                    this.growthTick((Level)level, pos, state, crop);
                }
            } else {
                level.destroyBlock(pos, true);
            }
        }
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity;
        ClimateRange range = this.climateRange.get();
        BlockPos sourcePos = pos.below();
        text.accept(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
        text.accept(FarmlandBlock.getHydrationTooltip(level, sourcePos, range, false));
        IFarmland farmland = null;
        BlockEntity blockEntity2 = level.getBlockEntity(sourcePos);
        if (blockEntity2 instanceof IFarmland) {
            IFarmland found;
            farmland = found = (IFarmland)blockEntity2;
        } else {
            blockEntity2 = level.getBlockEntity(sourcePos.below());
            if (blockEntity2 instanceof IFarmland) {
                IFarmland found;
                farmland = found = (IFarmland)blockEntity2;
            }
        }
        if (farmland != null) {
            farmland.addTooltipInfo(text);
        }
        if ((blockEntity = level.getBlockEntity(pos)) instanceof CropBlockEntity) {
            CropBlockEntity crop = (CropBlockEntity)blockEntity;
            if (isDebug) {
                text.accept((Component)Component.literal((String)String.format("[Debug] Growth = %.4f Yield = %.4f Expiry = %.4f Last Tick = %d Delta = %d", Float.valueOf(crop.getGrowth()), Float.valueOf(crop.getYield()), Float.valueOf(crop.getExpiry()), crop.getLastGrowthTick(), Calendars.get((LevelReader)level).getTicks() - crop.getLastGrowthTick())));
            }
            if (crop.getGrowth() >= 1.0f) {
                text.accept((Component)Component.translatable((String)"tfc.tooltip.farmland.mature"));
            }
        }
    }

    @Override
    public void growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (!level.isClientSide() && CropHelpers.growthTick(level, pos, state, crop)) {
            this.postGrowthTick(level, pos, state, crop);
        }
    }

    @Override
    public ClimateRange getClimateRange() {
        return this.climateRange.get();
    }

    @Override
    public float getNForGrowth() {
        return this.nNeeded;
    }

    @Override
    public float getPForGrowth() {
        return this.pNeeded;
    }

    @Override
    public float getKForGrowth() {
        return this.kNeeded;
    }

    protected abstract void postGrowthTick(Level var1, BlockPos var2, BlockState var3, CropBlockEntity var4);
}

