/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeadCropBlock
extends TFCBushBlock
implements HoeOverlayBlock {
    public static final BooleanProperty MATURE = TFCBlockStateProperties.MATURE;
    private final Supplier<ClimateRange> climateRange;

    public DeadCropBlock(ExtendedProperties properties, Crop crop) {
        this(properties, crop.getClimateRange());
    }

    public DeadCropBlock(ExtendedProperties properties, Supplier<ClimateRange> range) {
        super(properties);
        this.climateRange = range;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)MATURE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        text.accept(FarmlandBlock.getHydrationTooltip(level, pos.below(), range, false));
        text.accept(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
        if (((Boolean)state.getValue((Property)MATURE)).booleanValue()) {
            text.accept((Component)Component.translatable((String)"tfc.tooltip.farmland.mature"));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MATURE});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)MATURE) != false ? CropBlock.FULL_SHAPE : CropBlock.QUARTER_SHAPE;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.getBlockState(pos.below()), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : state;
    }
}

