/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public interface IPickableCrop {
    default public ItemStack yieldItemStack(Item item, float yield, RandomSource random) {
        return new ItemStack((ItemLike)item, Mth.floor((float)(Mth.lerp((float)yield, (float)1.0f, (float)5.0f) + (float)random.nextInt(2))));
    }

    @Nullable
    default public ItemInteractionResult getItemInteractionResult(BlockState state, Level level, BlockPos pos, Player player, CropBlockEntity crop) {
        CropBlock cropBlock = (CropBlock)state.getBlock();
        float yield = crop.getYield();
        int age = (Integer)state.getValue((Property)cropBlock.getAgeProperty());
        RandomSource random = level.getRandom();
        int maxAge = cropBlock.getMaxAge();
        if (age == maxAge - 1 && this.getFirstFruit() != null) {
            crop.setGrowth(Mth.nextFloat((RandomSource)random, (float)0.4f, (float)0.5f));
            crop.setYield(0.0f);
            cropBlock.postGrowthTick(level, pos, state, crop);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getFirstFruit(), yield, random));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (age == maxAge) {
            crop.setGrowth(Mth.nextFloat((RandomSource)random, (float)0.5f, (float)0.6f));
            crop.setYield(0.0f);
            cropBlock.postGrowthTick(level, pos, state, crop);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.yieldItemStack(this.getSecondFruit(), yield, random));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return null;
    }

    @Nullable
    public Item getFirstFruit();

    public Item getSecondFruit();
}

