/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.HorizontalPipeBlock;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.DefaultCropBlock;
import net.dries007.tfc.common.blocks.crop.WildSpreadingCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class SpreadingCropBlock
extends DefaultCropBlock
implements HorizontalPipeBlock {
    private final Supplier<Supplier<? extends Block>> fruit;

    public static SpreadingCropBlock create(ExtendedProperties properties, int stages, Crop crop, Supplier<Supplier<? extends Block>> fruit) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(stages - 1);
        return new SpreadingCropBlock(properties, stages - 1, TFCBlocks.DEAD_CROPS.get((Object)crop), TFCItems.CROP_SEEDS.get((Object)crop), crop.getNitrogen(), crop.getPhosphorous(), crop.getPotassium(), ClimateRanges.CROPS.get((Object)crop), fruit){

            @Override
            public IntegerProperty getAgeProperty() {
                return property;
            }
        };
    }

    protected SpreadingCropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, float nitrogen, float phosphorous, float potassium, Supplier<ClimateRange> climateRange, Supplier<Supplier<? extends Block>> fruit) {
        super(properties, maxAge, dead, seeds, nitrogen, phosphorous, potassium, climateRange);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.fruit = fruit;
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        int fruitAround = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Block fruit = this.getFruit();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutable.setWithOffset((Vec3i)pos, d);
            BlockState offsetState = level.getBlockState((BlockPos)mutable);
            if (!Helpers.isBlock(offsetState, fruit) || ++fruitAround <= 2) continue;
            return 0.9f;
        }
        return super.getGrowthLimit(level, pos, state);
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        super.postGrowthTick(level, pos, state, crop);
        if (crop.getGrowth() >= 1.0f) {
            Direction offset = Direction.Plane.HORIZONTAL.getRandomDirection(level.getRandom());
            BlockPos fruitPos = pos.relative(offset);
            Block fruitBlock = this.getFruit();
            BlockState fruitState = fruitBlock.defaultBlockState();
            BlockState growingOn = level.getBlockState(fruitPos.below());
            if (Helpers.isBlock(growingOn, TFCTags.Blocks.SPREADING_FRUIT_GROWS_ON) && level.getBlockState(fruitPos).canBeReplaced()) {
                level.setBlockAndUpdate(fruitPos, fruitState);
                BlockEntity blockEntity = level.getBlockEntity(fruitPos);
                if (blockEntity instanceof DecayingBlockEntity) {
                    DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
                    decaying.setStack(new ItemStack((ItemLike)fruitBlock));
                }
                crop.setGrowth(Mth.nextFloat((RandomSource)level.getRandom(), (float)0.6f, (float)0.72f));
            }
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        state = super.updateShape(state, facing, facingState, level, pos, facingPos);
        return Helpers.setProperty(state, (Property)PROPERTY_BY_DIRECTION.get(facing), facingState.getBlock() == this.fruit.get().get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return WildSpreadingCropBlock.updateBlockState(context.getLevel(), context.getClickedPos(), super.getStateForPlacement(context), this.getFruit());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{NORTH, SOUTH, EAST, WEST}));
    }

    public Block getFruit() {
        return this.fruit.get().get();
    }
}

