/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BarrelRackBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.block.BarrelComponent;
import net.dries007.tfc.common.component.item.ItemComponent;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BarrelBlock
extends SealableDeviceBlock {
    public static final VoxelShape SHAPE_Z = BarrelBlock.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)12.0, (double)16.0);
    public static final VoxelShape SHAPE_X = BarrelBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    public static final VoxelShape RACK_SHAPE = Shapes.or((VoxelShape)BarrelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BarrelBlock.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), BarrelBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), BarrelBlock.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), BarrelBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final VoxelShape SHAPE_Z_RACK = Shapes.or((VoxelShape)SHAPE_Z, (VoxelShape)RACK_SHAPE);
    public static final VoxelShape SHAPE_X_RACK = Shapes.or((VoxelShape)SHAPE_X, (VoxelShape)RACK_SHAPE);
    public static final EnumProperty<Direction> FACING = TFCBlockStateProperties.FACING_NOT_DOWN;
    public static final BooleanProperty RACK = TFCBlockStateProperties.RACK;

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).ifPresent(barrel -> {
            boolean previousSealed = (Boolean)state.getValue((Property)SEALED);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                barrel.onUnseal();
            } else {
                barrel.onSeal();
            }
        });
    }

    public BarrelBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SEALED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.UP)).setValue((Property)RACK, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BarrelBlockEntity barrel = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).orElse(null);
        if (barrel != null) {
            if (stack.isEmpty() && player.isShiftKeyDown()) {
                if (((Boolean)state.getValue((Property)RACK)).booleanValue() && level.getBlockState(pos.above()).isAir() && hitResult.getLocation().y - (double)pos.getY() > 0.875) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)((Block)TFCBlocks.BARREL_RACK.get()).asItem()));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)RACK, (Comparable)Boolean.valueOf(false)));
                } else {
                    BarrelBlock.toggleSeal(level, pos, state);
                }
                level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.85f);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (Helpers.isItem(stack, (ItemLike)((Block)TFCBlocks.BARREL_RACK.get()).asItem()) && state.getValue(FACING) != Direction.UP && !((Boolean)state.getValue((Property)RACK)).booleanValue()) {
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)RACK, (Comparable)Boolean.valueOf(true))).setValue(FACING, (Comparable)player.getDirection().getOpposite()));
                Helpers.playPlaceSound(player, (LevelAccessor)level, pos, state);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (FluidHelpers.transferBetweenBlockEntityAndItem(stack, barrel, player, hand)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)barrel, barrel.getBlockPos());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)SEALED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (Helpers.isItem(player.getMainHandItem(), (TagKey<Item>)Tags.Items.RODS_WOODEN)) {
                IFluidHandler tank = (IFluidHandler)barrel.getInventory();
                float fill = (float)tank.getFluidInTank(0).getAmount() / (float)tank.getTankCapacity(0);
                int note = Mth.ceil((float)(fill * 24.0f));
                level.playSeededSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (Holder)SoundEvents.NOTE_BLOCK_BASEDRUM, SoundSource.RECORDS, 3.0f, NoteBlock.getPitchFromNote((int)note), level.random.nextLong());
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        BarrelComponent barrel = (BarrelComponent)stack.getOrDefault(TFCComponents.BARREL, (Object)BarrelComponent.EMPTY);
        if (!barrel.isEmpty()) {
            tooltip.add((Component)Tooltips.contents());
            Object2IntArrayMap contents = new Object2IntArrayMap();
            for (ItemStack content : barrel.itemContent()) {
                if (content.isEmpty()) continue;
                contents.mergeInt((Object)new ItemComponent(content.copyWithCount(1)), content.getCount(), Integer::sum);
            }
            for (Object2IntMap.Entry entry : contents.object2IntEntrySet()) {
                tooltip.add((Component)Tooltips.countOfItem(((ItemComponent)entry.getKey()).stack(), entry.getIntValue()));
            }
            if (!barrel.fluidContent().isEmpty()) {
                tooltip.add((Component)Tooltips.fluidUnitsOf(barrel.fluidContent()));
            }
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Direction)state.getValue(FACING)).getAxis().isHorizontal() && facing == Direction.DOWN && !level.getBlockState(facingPos).isFaceSturdy((BlockGetter)level, facingPos, Direction.UP, SupportType.CENTER)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            BlockPos pos;
            Direction dir = context.getClickedFace();
            if (dir == Direction.DOWN) {
                dir = Direction.UP;
            }
            state = (BlockState)state.setValue(FACING, (Comparable)dir);
            Level level = context.getLevel();
            if (Helpers.isBlock(level.getBlockState(pos = context.getClickedPos()), (Block)TFCBlocks.BARREL_RACK.get())) {
                return (BlockState)((BlockState)state.setValue(FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)RACK, (Comparable)Boolean.valueOf(true));
            }
            if (!level.getBlockState(pos.below()).isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP, SupportType.CENTER)) {
                return null;
            }
        }
        return state;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.setValue(FACING, (Comparable)direction.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean rack = (Boolean)state.getValue((Property)RACK);
        return switch (((Direction)state.getValue(FACING)).getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (rack) {
                    yield SHAPE_X_RACK;
                }
                yield SHAPE_X;
            }
            case Direction.Axis.Z -> {
                if (rack) {
                    yield SHAPE_Z_RACK;
                }
                yield SHAPE_Z;
            }
            case Direction.Axis.Y -> super.getShape(state, level, pos, context);
        };
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!Helpers.isBlock(state, newState.getBlock()) && ((Boolean)state.getValue((Property)RACK)).booleanValue() && !(newState.getBlock() instanceof BarrelRackBlock) && !isMoving) {
            Helpers.spawnItem(level, pos, new ItemStack((ItemLike)TFCBlocks.BARREL_RACK.get()));
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING, RACK}));
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return TFCConfig.SERVER.barrelEnableAutomation.get();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BarrelBlockEntity barrel;
        FluidStack tank;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BarrelBlockEntity && !(tank = ((BarrelBlockEntity.BarrelInventory)(barrel = (BarrelBlockEntity)blockEntity).getInventory()).getFluidInTank(0)).isEmpty()) {
            return Mth.clamp((int)(tank.getAmount() * 15 / TFCConfig.SERVER.barrelCapacity.get()), (int)1, (int)15);
        }
        return 0;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (((Boolean)state.getValue((Property)RACK)).booleanValue()) {
            this.playerWillDestroy(level, pos, state, player);
            return level.setBlock(pos, ((Block)TFCBlocks.BARREL_RACK.get()).defaultBlockState(), level.isClientSide ? 11 : 3);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (TFCConfig.SERVER.barrelEnableRedstoneSeal.get().booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            this.handleNeighborChanged(state, level, pos, barrel::onSeal, barrel::onUnseal);
        }
    }

    @Override
    public boolean isStackSealed(ItemStack stack) {
        return stack.has(TFCComponents.BARREL);
    }
}

