/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Locale;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CalendarClockBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CalendarClockBlock
extends DeviceBlock {
    public static EnumProperty<Mode> MODE = TFCBlockStateProperties.CLOCK_MODE;
    public static DirectionProperty FACING = BlockStateProperties.FACING;
    private static final VoxelShape SHAPE_UP = CalendarClockBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_DOWN = CalendarClockBlock.box((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_NORTH = CalendarClockBlock.box((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = CalendarClockBlock.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
    private static final VoxelShape SHAPE_EAST = CalendarClockBlock.box((double)0.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_WEST = CalendarClockBlock.box((double)14.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);

    public CalendarClockBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(MODE, (Comparable)((Object)Mode.HOUR))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = Helpers.getSupportedDirectionalStateForPlacement(this, context, false);
        if (state == null) {
            return null;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        Level level = context.getLevel();
        BlockState facingState = level.getBlockState((pos = context.getClickedPos()).relative(facing.getOpposite()));
        if (Helpers.isBlock(facingState, TFCTags.Blocks.CLOCK_READABLE)) {
            state = (BlockState)state.setValue((Property)FACING, (Comparable)facing);
        }
        return state;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CalendarClockBlockEntity) {
            CalendarClockBlockEntity clock = (CalendarClockBlockEntity)blockEntity;
            clock.needsInstantUpdate();
        }
        level.updateNeighborsAt(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()), (Block)this);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.mayBuild()) {
            if (level.isClientSide) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof CalendarClockBlockEntity) {
                    CalendarClockBlockEntity clock = (CalendarClockBlockEntity)blockEntity;
                    clock.needsInstantUpdate();
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            BlockState blockState = switch (((Mode)((Object)state.getValue(MODE))).ordinal()) {
                case 0, 1 -> {
                    Direction oppositeDirection = direction.getOpposite();
                    BlockState blockState1 = level.getBlockState(pos.relative(oppositeDirection));
                    BlockState blockState2 = level.getBlockState(pos.relative(oppositeDirection).relative(oppositeDirection));
                    if (Helpers.isBlock(blockState1, TFCTags.Blocks.CLOCK_READABLE)) {
                        yield (BlockState)state.setValue(MODE, (Comparable)((Object)Mode.TIMER));
                    }
                    if (Helpers.isBlock(blockState2, TFCTags.Blocks.CLOCK_READABLE)) {
                        yield (BlockState)state.setValue(MODE, (Comparable)((Object)Mode.TIMER));
                    }
                    yield (BlockState)state.setValue(MODE, (Comparable)((Object)Mode.HOUR));
                }
                case 2 -> (BlockState)state.setValue(MODE, (Comparable)((Object)Mode.HOUR));
                default -> (BlockState)state.setValue(MODE, (Comparable)((Object)Mode.MONTH));
            };
            level.setBlock(pos, blockState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CalendarClockBlockEntity) {
                CalendarClockBlockEntity clock = (CalendarClockBlockEntity)blockEntity;
                clock.needsInstantUpdate();
            }
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MODE}).add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
        };
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos blockPos, BlockPos facingPos) {
        if (facing == ((Direction)state.getValue((Property)FACING)).getOpposite() && !this.canSurvive(state, (LevelReader)level, blockPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, blockPos, facingPos);
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (blockState.getValue((Property)FACING) == side && !((Mode)((Object)blockState.getValue(MODE))).equals((Object)Mode.TIMER)) {
            return this.getSignal(blockState, blockAccess, pos, side);
        }
        return 0;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.getBlockEntity(pos);
        if (blockEntity instanceof CalendarClockBlockEntity) {
            CalendarClockBlockEntity clock = (CalendarClockBlockEntity)blockEntity;
            return clock.getRedstoneSignal();
        }
        return 0;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CalendarClockBlock.canSurvive(level, pos, (Direction)state.getValue((Property)FACING));
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos, Direction facing) {
        BlockPos blockpos = pos.relative(facing.getOpposite());
        BlockState blockstate = level.getBlockState(blockpos);
        if (Helpers.isBlock(blockstate, TFCTags.Blocks.CLOCK_READABLE)) {
            return true;
        }
        return blockstate.isFaceSturdy((BlockGetter)level, blockpos, facing);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public static enum Mode implements StringRepresentable
    {
        HOUR,
        MONTH,
        TIMER;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String getSerializedName() {
            return this.serializedName;
        }
    }
}

