/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.MoldTableBlock;
import net.dries007.tfc.util.ChannelFlow;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChannelBlock
extends ExtendedBlock
implements EntityBlockExtension {
    public static final VoxelShape CHANNEL_FLOW_CENTER_SHAPE = Block.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape CHANNEL_FLOW_UP_SHAPE = Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape CHANNEL_FLOW_EAST_SHAPE = Block.box((double)10.0, (double)1.0, (double)6.0, (double)17.0, (double)4.0, (double)10.0);
    public static final VoxelShape CHANNEL_FLOW_EAST_SHAPE_LONG = Block.box((double)10.0, (double)1.0, (double)6.0, (double)22.0, (double)4.0, (double)10.0);
    public static final VoxelShape CHANNEL_FLOW_LONG_FALL_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(facing -> facing.getKey() != Direction.UP).collect(Util.toMap());
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    public static final BooleanProperty WITH_METAL = BooleanProperty.create((String)"with_metal");
    private static final VoxelShape[] SHAPES = new VoxelShape[16];

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(channel.getNumberOfFlows()));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.isClientSide()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CHANNEL.get()).ifPresent(channel -> channel.notifyBrokenLink(channel.getNumberOfFlows()));
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    public ChannelBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WITH_METAL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Boolean)state.getValue((Property)NORTH) != false ? 1 << Direction.NORTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)EAST) != false ? 1 << Direction.EAST.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)SOUTH) != false ? 1 << Direction.SOUTH.get2DDataValue() : 0) | ((Boolean)state.getValue((Property)WEST) != false ? 1 << Direction.WEST.get2DDataValue() : 0)];
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState adjacentState, LevelAccessor level, BlockPos pos, BlockPos adjacentPos) {
        for (Direction dir : Helpers.DIRECTIONS) {
            if (dir == Direction.UP) continue;
            int maxDistance = dir == Direction.DOWN ? 127 : 1;
            boolean isAdjacentConnectable = false;
            for (int i = 1; i < maxDistance + 1; i = (int)((byte)(i + 1))) {
                BlockPos relative = pos.relative(dir, i);
                BlockState blockState = level.getBlockState(relative);
                Block block = blockState.getBlock();
                if (block instanceof ChannelBlock || block instanceof CrucibleBlock || block instanceof MoldTableBlock) {
                    isAdjacentConnectable = true;
                    break;
                }
                if (!blockState.isAir()) break;
            }
            state = (BlockState)state.setValue((Property)DirectionPropertyBlock.getProperty(dir), (Comparable)Boolean.valueOf(isAdjacentConnectable));
        }
        return state;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        boolean isLocationPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        boolean isChannelPowered = (Boolean)state.getValue((Property)TRIGGERED);
        if (isLocationPowered && !isChannelPowered) {
            this.activate((LevelAccessor)level, pos);
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isLocationPowered && isChannelPowered) {
            level.setBlock(pos, (BlockState)state.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{EAST, SOUTH, WEST, NORTH, DOWN, TRIGGERED, WITH_METAL});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player instanceof ServerPlayer) {
            this.activate((LevelAccessor)level, pos);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean activate(LevelAccessor level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            Optional crucible = level.getBlockEntity(pos.relative(dir), (BlockEntityType)TFCBlockEntities.CRUCIBLE.get());
            if (!crucible.isPresent()) continue;
            ChannelFlow.fromCrucible(level, (CrucibleBlockEntity)crucible.get(), pos);
            return true;
        }
        return false;
    }

    static {
        VoxelShape base = ChannelBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
        VoxelShape east = ChannelBlock.box((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0, (double)11.0);
        VoxelShape south = ChannelBlock.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0, (double)16.0);
        VoxelShape west = ChannelBlock.box((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0);
        VoxelShape north = ChannelBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)10.0);
        VoxelShape[] directions = new VoxelShape[]{south, west, north, east};
        for (int i = 0; i < SHAPES.length; ++i) {
            VoxelShape shape = base;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if ((i >> direction.get2DDataValue() & 1) != 1) continue;
                shape = Shapes.or((VoxelShape)shape, (VoxelShape)directions[direction.get2DDataValue()]);
            }
            ChannelBlock.SHAPES[i] = shape;
        }
    }
}

