/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.function.BiPredicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CharcoalForgeBlock
extends DeviceBlock
implements IBellowsConsumer {
    public static final IntegerProperty HEAT = TFCBlockStateProperties.HEAT_LEVEL;
    private static final MultiBlock FORGE_MULTIBLOCK;

    public static boolean isValid(LevelAccessor level, BlockPos pos) {
        return FORGE_MULTIBLOCK.test(level, pos);
    }

    public static boolean isForgeInsulationBlock(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.CHARCOAL_FORGE_INSULATION);
    }

    public CharcoalForgeBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)HEAT, (Comparable)Integer.valueOf(0)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        int i;
        if ((Integer)state.getValue((Property)HEAT) == 0) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.875;
        double z = (double)pos.getZ() + 0.5;
        if (rand.nextInt(10) == 0) {
            level.playLocalSound(x, y, z, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
        }
        for (i = 0; i < 1 + rand.nextInt(2); ++i) {
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.07, 0.0);
        }
        for (i = 0; i < rand.nextInt(3); ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
        if (rand.nextInt(8) == 1) {
            level.addParticle((ParticleOptions)ParticleTypes.LAVA, x + (double)Helpers.triangle(rand), y + rand.nextDouble(), z + (double)Helpers.triangle(rand), 0.0, 0.005, 0.0);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity && (Integer)state.getValue((Property)HEAT) > 0) {
            entity.hurt(entity.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).ifPresent(forge -> forge.intakeAir(amount));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HEAT}));
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return (Integer)state.getValue((Property)HEAT) > 0 && !CharcoalForgeBlock.isValid(world, currentPos) ? (BlockState)state.setValue((Property)HEAT, (Comparable)Integer.valueOf(0)) : state;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return TFCConfig.SERVER.charcoalForgeEnableAutomation.get();
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        CharcoalForgeBlockEntity charcoalForge;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CharcoalForgeBlockEntity && !((ItemStackHandler)(charcoalForge = (CharcoalForgeBlockEntity)blockEntity).getInventory()).getStackInSlot(0).isEmpty()) {
            int maxSlot = 4;
            for (int i = 0; i <= 4; ++i) {
                if (!((ItemStackHandler)charcoalForge.getInventory()).getStackInSlot(i).isEmpty()) continue;
                return Mth.clamp((int)(i * 15 / 5), (int)1, (int)15);
            }
            return 15;
        }
        return 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CharcoalForgeBlockEntity forge = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.CHARCOAL_FORGE.get()).orElse(null);
        if (forge != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)forge, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CharcoalPileBlock.SHAPE_BY_LAYER[7];
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if ((Integer)state.getValue((Property)HEAT) > 0) {
            if (CharcoalForgeBlock.isValid((LevelAccessor)level, pos)) {
                Helpers.fireSpreaderTick(level, pos.above(), rand, 3);
            } else {
                level.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)HEAT, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    static {
        BiPredicate<LevelAccessor, BlockPos> skyMatcher = BlockAndTintGetter::canSeeSky;
        BiPredicate<LevelAccessor, BlockPos> isValidSide = (level, pos) -> CharcoalForgeBlock.isForgeInsulationBlock(level.getBlockState(pos));
        BlockPos origin = BlockPos.ZERO;
        FORGE_MULTIBLOCK = new MultiBlock().match(origin.above(), state -> state.isAir() || Helpers.isBlock(state, TFCTags.Blocks.CHARCOAL_FORGE_INVISIBLE)).matchOneOf(origin.above(), new MultiBlock().match(origin, skyMatcher).matchHorizontal(origin, skyMatcher, 1).matchHorizontal(origin, skyMatcher, 2)).matchEachDirection(origin, isValidSide, new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN}, 1);
    }
}

