/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.FirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class FirepitBlock
extends BottomSupportedDeviceBlock
implements IGhostBlockHandler,
IBellowsConsumer {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty SMOKE_LEVEL = TFCBlockStateProperties.SMOKE_LEVEL;
    public static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)FirepitBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)FirepitBlock.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0));

    public static boolean tryInsertLog(Player player, ItemStack held, AbstractFirepitBlockEntity<?> firepit, boolean overrideBehavior) {
        Object inventory = firepit.getInventory();
        if (overrideBehavior) {
            for (int i = 0; i <= 3; ++i) {
                if (!inventory.getStackInSlot(i).isEmpty() || !inventory.isItemValid(3, held)) continue;
                Helpers.playPlaceSound(player, (LevelAccessor)player.level(), player.blockPosition(), SoundType.WOOD);
                inventory.setStackInSlot(i, player.isCreative() ? held.copy().split(1) : held.split(1));
                firepit.markForSync();
                return true;
            }
        }
        return false;
    }

    public FirepitBlock(ExtendedProperties properties) {
        this(properties, BASE_SHAPE);
    }

    public FirepitBlock(ExtendedProperties properties, VoxelShape shape) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP, shape);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)SMOKE_LEVEL, (Comparable)Integer.valueOf(0))).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state != null ? (BlockState)state.setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis()) : null;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            Helpers.fireSpreaderTick(level, pos, random, 2);
        }
    }

    public void forcedAnimateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + this.getParticleHeightOffset();
        double z = (double)pos.getZ() + 0.5;
        int smoke = (Integer)state.getValue((Property)SMOKE_LEVEL);
        for (int i = 0; i < 1 + random.nextInt(3); ++i) {
            level.addAlwaysVisibleParticle((ParticleOptions)TFCParticles.SMOKES.get(smoke).get(), x + (double)(Helpers.triangle(random) * 0.5f), y + random.nextDouble(), z + (double)(Helpers.triangle(random) * 0.5f), 0.0, 0.07, 0.0);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        FirepitBlockEntity firepit;
        BlockEntity blockEntity;
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + this.getParticleHeightOffset();
        double z = (double)pos.getZ() + 0.5;
        int smoke = (Integer)state.getValue((Property)SMOKE_LEVEL);
        if (random.nextInt(10) == 0) {
            level.playLocalSound(x, y, z, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
        for (int i = 0; i < random.nextInt(4 + smoke); ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + (double)(Helpers.triangle(random) * 0.5f), y + random.nextDouble(), z + (double)(Helpers.triangle(random) * 0.5f), 0.0, 0.005, 0.0);
        }
        if (random.nextInt(6 - smoke) == 1) {
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x + (double)(Helpers.triangle(random) * 0.5f), y + random.nextDouble(), z + (double)(Helpers.triangle(random) * 0.5f), 0.0, 0.005, 0.0);
        }
        if (random.nextInt(4) == 0 && (blockEntity = level.getBlockEntity(pos)) instanceof FirepitBlockEntity && (firepit = (FirepitBlockEntity)blockEntity).getAsh() > 0) {
            for (int i = 0; i < firepit.getAsh(); ++i) {
                level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)14733204).toVector3f(), 1.0f), x + (double)(Helpers.triangle(random) * 0.5f), y - this.getParticleHeightOffset() + 0.25, z + (double)(Helpers.triangle(random) * 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)level.getBlockState(pos).getValue((Property)LIT)).booleanValue()) {
            entity.hurt(entity.damageSources().hotFloor(), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState lookState, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        if (Helpers.isItem(item, (ItemLike)TFCItems.POT.get())) {
            return (BlockState)((BlockState)((Block)TFCBlocks.POT.get()).defaultBlockState().setValue((Property)LIT, (Comparable)((Boolean)lookState.getValue((Property)LIT)))).setValue(AXIS, (Comparable)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)));
        }
        if (Helpers.isItem(item, (ItemLike)TFCItems.WROUGHT_IRON_GRILL.get())) {
            return (BlockState)((BlockState)((Block)TFCBlocks.GRILL.get()).defaultBlockState().setValue((Property)LIT, (Comparable)((Boolean)lookState.getValue((Property)LIT)))).setValue(AXIS, (Comparable)((Direction.Axis)level.getBlockState(pos).getValue(AXIS)));
        }
        return null;
    }

    @Override
    public float alpha() {
        return 0.33f;
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.FIREPIT.get()).ifPresent(firepit -> firepit.intakeAir(amount));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, SMOKE_LEVEL, AXIS});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FirepitBlockEntity) {
            FirepitBlockEntity firepit = (FirepitBlockEntity)blockEntity;
            if (stack.getItem() == TFCItems.POT.get() || stack.getItem() == TFCItems.WROUGHT_IRON_GRILL.get()) {
                if (!level.isClientSide) {
                    Block newBlock = stack.getItem() == TFCItems.POT.get() ? (Block)TFCBlocks.POT.get() : (Block)TFCBlocks.GRILL.get();
                    AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, firepit, newBlock);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        TFCAdvancements.FIREPIT_CREATED.trigger(serverPlayer, newBlock.defaultBlockState());
                    }
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (FirepitBlock.tryInsertLog(player, stack, firepit, true)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && firepit.getAsh() > 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POWDERS.get((Object)Powder.WOOD_ASH).get(), firepit.getAsh()));
                firepit.setAsh(0);
                Helpers.playSound(level, pos, SoundEvents.SAND_BREAK);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)firepit, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return rot == Rotation.COUNTERCLOCKWISE_90 || rot == Rotation.CLOCKWISE_90 ? (BlockState)state.cycle(AXIS) : state;
    }

    public double getParticleHeightOffset() {
        return 0.35;
    }
}

