/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Optional;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PowderkegBlock
extends SealableDeviceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final VoxelShape SHAPE = PowderkegBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_UNSEALED = Shapes.join((VoxelShape)SHAPE, (VoxelShape)PowderkegBlock.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(powderkeg -> {
            boolean previousSealed = (Boolean)state.getValue((Property)SEALED);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                    powderkeg.setLit(false, null);
                    Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
                }
                powderkeg.onUnseal();
            } else {
                level.neighborChanged(pos, (Block)TFCBlocks.POWDERKEG.get(), pos);
                powderkeg.onSeal();
            }
        });
    }

    public PowderkegBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SEALED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        PowderkegBlockEntity powderkeg = level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).orElse(null);
        if (powderkeg != null) {
            if (stack.isEmpty() && player.isShiftKeyDown()) {
                if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                    powderkeg.setLit(false, (Entity)player);
                    Helpers.playSound(level, pos, SoundEvents.FIRE_EXTINGUISH);
                } else {
                    PowderkegBlock.toggleSeal(level, pos, state);
                    Helpers.playPlaceSound(player, (LevelAccessor)level, pos, state);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!level.isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)powderkeg, powderkeg.getBlockPos());
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return TFCConfig.CLIENT.displayItemContentsAsImages.get() != false ? TooltipBlock.buildInventoryTooltip(((ItemListComponent)stack.getOrDefault(TFCComponents.CONTENTS, (Object)ItemListComponent.EMPTY)).contents(), 4, 3) : Optional.empty();
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, explosion.getDirectSourceEntity()));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int count = random.nextInt(3) + 5;
            for (int i = 0; i < count; ++i) {
                double x = (float)pos.getX() + random.nextFloat();
                double z = (float)pos.getZ() + random.nextFloat();
                double y = (float)pos.getY() + 0.98f + random.nextFloat() / 5.0f;
                level.addParticle((ParticleOptions)TFCParticles.SPARK.get(), x, y, z, (double)Helpers.uniform(random, -5.0f, 5.0f), (double)(3.0f + random.nextFloat()), (double)Helpers.uniform(random, -5.0f, 5.0f));
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{LIT}));
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)SEALED)).booleanValue()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, null));
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (level.hasNeighborSignal(pos) && !((Boolean)state.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)SEALED)).booleanValue()) {
            level.getBlockEntity(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, null));
        }
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SEALED) != false ? SHAPE : SHAPE_UNSEALED;
    }
}

