/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TooltipBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.item.ItemListComponent;
import net.dries007.tfc.common.component.size.IItemSize;
import net.dries007.tfc.common.component.size.Size;
import net.dries007.tfc.common.component.size.Weight;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SealableDeviceBlock
extends DeviceBlock
implements IItemSize,
TooltipBlock {
    public static final BooleanProperty SEALED = TFCBlockStateProperties.SEALED;
    public static final BooleanProperty POWERED = TFCBlockStateProperties.POWERED;
    private static final VoxelShape SHAPE = SealableDeviceBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_UNSEALED = Shapes.join((VoxelShape)SHAPE, (VoxelShape)SealableDeviceBlock.box((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);

    public SealableDeviceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SEALED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)SEALED) != false ? SHAPE : SHAPE_UNSEALED;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.getStateForPlacement((LevelAccessor)context.getLevel(), context.getClickedPos());
        if (this.isStackSealed(context.getItemInHand())) {
            state = (BlockState)state.setValue((Property)SEALED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockState getStateForPlacement(LevelAccessor level, BlockPos pos) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        List<ItemStack> contents;
        if (!TFCConfig.CLIENT.displayItemContentsAsImages.get().booleanValue() && !Helpers.isEmpty(contents = ((ItemListComponent)stack.getOrDefault(TFCComponents.CONTENTS, (Object)ItemListComponent.EMPTY)).contents())) {
            tooltip.add((Component)Tooltips.contents());
            Helpers.addInventoryTooltipInfo(contents, tooltip);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SEALED, POWERED});
    }

    @Override
    public Size getSize(ItemStack stack) {
        return Size.HUGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return this.isStackSealed(stack) ? Weight.VERY_HEAVY : Weight.HEAVY;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockEntity entity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (((Boolean)state.getValue((Property)SEALED)).booleanValue() && (entity = level.getBlockEntity(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.saveToItem(stack, (HolderLookup.Provider)level.registryAccess());
            this.modifyWeight(stack);
        }
        return stack;
    }

    @Override
    protected void beforeRemove(InventoryBlockEntity<?> entity) {
        if (!((Boolean)entity.getBlockState().getValue((Property)SEALED)).booleanValue()) {
            entity.ejectInventory();
        }
    }

    public void handleNeighborChanged(BlockState state, Level level, BlockPos pos, Runnable onSeal, Runnable onUnseal) {
        boolean signal = level.hasNeighborSignal(pos);
        if (signal != (Boolean)state.getValue((Property)POWERED)) {
            if (signal != (Boolean)state.getValue((Property)SEALED)) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal))).setValue((Property)SEALED, (Comparable)Boolean.valueOf(signal)));
                if (signal) {
                    onSeal.run();
                } else {
                    onUnseal.run();
                }
            } else {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(signal)));
            }
        }
    }

    public boolean isStackSealed(ItemStack stack) {
        return stack.has(TFCComponents.CONTENTS);
    }
}

