/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SluiceBlock
extends DeviceBlock
implements EntityBlockExtension {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty UPPER = TFCBlockStateProperties.UPPER;
    private static final VoxelShape[] TOP_SHAPES = Helpers.computeHorizontalShapes(SluiceBlock::createTopShape);
    private static final VoxelShape[] BOTTOM_SHAPES = Helpers.computeHorizontalShapes(SluiceBlock::createBottomShape);

    public static BlockPos getFluidOutputPos(BlockState state, BlockPos pos) {
        return pos.relative((Direction)state.getValue((Property)FACING), 2).below();
    }

    private static VoxelShape createTopShape(Direction direction) {
        return Shapes.or((VoxelShape)Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 10.0, 1.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape(direction, 0.0, 0.0, 1.0, 16.0, 9.0, 4.0), Helpers.rotateShape(direction, 0.0, 0.0, 4.0, 16.0, 12.0, 5.0), Helpers.rotateShape(direction, 0.0, 0.0, 5.0, 16.0, 11.0, 8.0), Helpers.rotateShape(direction, 0.0, 0.0, 8.0, 16.0, 14.0, 9.0), Helpers.rotateShape(direction, 0.0, 0.0, 9.0, 16.0, 13.0, 12.0), Helpers.rotateShape(direction, 0.0, 0.0, 12.0, 16.0, 16.0, 13.0), Helpers.rotateShape(direction, 0.0, 0.0, 13.0, 16.0, 15.0, 16.0)});
    }

    private static VoxelShape createBottomShape(Direction direction) {
        return Shapes.or((VoxelShape)Helpers.rotateShape(direction, 0.0, 0.0, 0.0, 16.0, 2.0, 1.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape(direction, 0.0, 0.0, 1.0, 16.0, 1.0, 4.0), Helpers.rotateShape(direction, 0.0, 0.0, 4.0, 16.0, 4.0, 5.0), Helpers.rotateShape(direction, 0.0, 0.0, 5.0, 16.0, 3.0, 8.0), Helpers.rotateShape(direction, 0.0, 0.0, 8.0, 16.0, 6.0, 9.0), Helpers.rotateShape(direction, 0.0, 0.0, 9.0, 16.0, 5.0, 12.0), Helpers.rotateShape(direction, 0.0, 0.0, 12.0, 16.0, 8.0, 13.0), Helpers.rotateShape(direction, 0.0, 0.0, 13.0, 16.0, 7.0, 16.0)});
    }

    public SluiceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UPPER, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{UPPER, FACING}));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        level.setBlockAndUpdate(pos.relative((Direction)state.getValue((Property)FACING)), (BlockState)state.setValue((Property)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Direction direction = context.getHorizontalDirection();
        Level level = context.getLevel();
        if (level.getBlockState(pos).canBeReplaced() && level.getBlockState(pos.relative(direction)).canBeReplaced()) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)UPPER, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int idx = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        return (Boolean)state.getValue((Property)UPPER) != false ? TOP_SHAPES[idx] : BOTTOM_SHAPES[idx];
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (((Boolean)state.getValue((Property)UPPER)).booleanValue() && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            item.setDeltaMovement(0.0, 0.0, 0.0);
        }
        super.entityInside(state, level, pos, entity);
    }

    @Override
    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos fluidPos;
        BlockState originalState;
        FluidState fluid;
        if (!level.isClientSide && (Helpers.isFluid(fluid = (originalState = level.getBlockState(fluidPos = SluiceBlock.getFluidOutputPos(state, pos))).getFluidState(), TFCTags.Fluids.USABLE_IN_SLUICE) || FluidHelpers.isMeltableIce(originalState))) {
            BlockState resultState = FluidHelpers.emptyFluidFrom(originalState);
            level.setBlockAndUpdate(fluidPos, resultState);
            if (!resultState.isAir()) {
                level.scheduleTick(fluidPos, resultState.getBlock(), 1);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!((Boolean)state.getValue((Property)UPPER)).booleanValue() && direction == facing.getOpposite() && !Helpers.isBlock(facingState, this)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((Boolean)state.getValue((Property)UPPER)).booleanValue() && direction == facing && !Helpers.isBlock(facingState, this)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        BlockPos fluidPos;
        BlockState fluidState;
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)FACING) && Helpers.isFluid((fluidState = level.getBlockState(fluidPos = SluiceBlock.getFluidOutputPos(state, pos))).getFluidState(), TFCTags.Fluids.USABLE_IN_SLUICE)) {
            level.setBlockAndUpdate(fluidPos, FluidHelpers.emptyFluidFrom(fluidState));
        }
        super.wasExploded(level, pos, explosion);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

