/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FloatingWaterPlantBlock
extends PlantBlock {
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    private final Supplier<? extends TagKey<Fluid>> fluidTag;

    public static FloatingWaterPlantBlock create(final RegistryPlant plant, Supplier<? extends TagKey<Fluid>> fluidTag, BlockBehaviour.Properties properties) {
        return new FloatingWaterPlantBlock(ExtendedProperties.of(properties), fluidTag){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected FloatingWaterPlantBlock(ExtendedProperties properties, Supplier<? extends TagKey<Fluid>> fluidTag) {
        super(properties);
        this.fluidTag = fluidTag;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random, pos)) {
            IntegerProperty ageProp = this.getPlant().getAgeProperty();
            BlockPos newPos = PlantRegrowth.spreadSelf(state, level, pos, random, 1, 2, 1);
            if (ageProp != null && newPos != null && level.getFluidState(newPos.below(5)).isEmpty() && !(level.getBlockState(newPos.below()).getBlock() instanceof RiverWaterBlock)) {
                level.setBlockAndUpdate(newPos, (BlockState)state.setValue((Property)ageProp, (Comparable)Integer.valueOf(0)));
            }
        }
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getFluidState(pos.below()).getTags().anyMatch(fluidTagKey -> fluidTagKey == this.fluidTag.get());
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

