/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.particle.Butterfly;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.BranchingCactusBlock;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PlantBlock
extends TFCBushBlock {
    public static final IntegerProperty AGE = TFCBlockStateProperties.AGE_3;
    protected static final VoxelShape PLANT_SHAPE = PlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public static PlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    public static PlantBlock createShrub(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){
            static final VoxelShape SHAPE = 2.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
                return SHAPE;
            }
        };
    }

    public static PlantBlock createShortShrub(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){
            static final VoxelShape SHAPE = 3.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
                return SHAPE;
            }
        };
    }

    public static PlantBlock createDry(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
                return 4.isDryBlockPlantable(level.getBlockState(pos.below()));
            }
        };
    }

    public static PlantBlock createPerchedEpiphyte(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
                return 5.isEpiphytePlantable(level.getBlockState(pos.below()));
            }
        };
    }

    public static PlantBlock createCactusFlower(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
                return state.getBlock() instanceof BranchingCactusBlock;
            }
        };
    }

    public static PlantBlock createFlowerbed(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){
            static final VoxelShape SHAPE = 7.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
                return SHAPE;
            }

            protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
                IntegerProperty ageProp = this.getPlant().getAgeProperty();
                if (!useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && ageProp != null && (Integer)state.getValue((Property)ageProp) < this.getMaxAgeValue()) {
                    return true;
                }
                return super.canBeReplaced(state, useContext);
            }

            @Nullable
            public BlockState getStateForPlacement(BlockPlaceContext context) {
                BlockState state = context.getLevel().getBlockState(context.getClickedPos());
                IntegerProperty ageProp = this.getPlant().getAgeProperty();
                if (ageProp != null && Helpers.isBlock(state, (Block)this)) {
                    return (BlockState)state.setValue((Property)ageProp, (Comparable)Integer.valueOf(Math.min(this.getMaxAgeValue(), (Integer)state.getValue((Property)ageProp) + 1)));
                }
                return super.getStateForPlacement(context);
            }
        };
    }

    public static boolean isDryBlockPlantable(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.DRY_PLANT_PLANTABLE_ON);
    }

    public static boolean isEpiphytePlantable(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.EPIPHYTE_PLANTABLE_ON);
    }

    protected PlantBlock(ExtendedProperties properties) {
        super(properties);
        BlockState stateDefinition = (BlockState)this.getStateDefinition().any();
        IntegerProperty ageProperty = this.getPlant().getAgeProperty();
        if (ageProperty != null) {
            stateDefinition = (BlockState)stateDefinition.setValue((Property)ageProperty, (Comparable)Integer.valueOf(0));
        }
        this.registerDefaultState(stateDefinition);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Butterfly but;
        if (random.nextInt(400) == 0 && Helpers.isBlock(state, (TagKey<Block>)BlockTags.FLOWERS) && Calendars.CLIENT.getHemispheralCalendarMonthOfYear(ClientHelpers.inNorthernHemisphere()).getSeason() == Season.SPRING && (but = Butterfly.getRandomButterfly(ClimateRenderCache.INSTANCE.getTemperature(), ClimateRenderCache.INSTANCE.getAverageGroundwater(), random)) != null) {
            level.addParticle((ParticleOptions)TFCParticles.BUTTERFLIES.get((Object)but).get(), (double)((float)pos.getX() + random.nextFloat()), (double)((float)pos.getY() + random.nextFloat()), (double)((float)pos.getZ() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PLANT_SHAPE;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        IntegerProperty ageProp = this.getPlant().getAgeProperty();
        if (ageProp != null) {
            int maxAge = this.getMaxAgeValue();
            int age = (Integer)state.getValue((Property)ageProp);
            if (random.nextDouble() < TFCConfig.SERVER.plantGrowthChance.get() && age < maxAge) {
                state = (BlockState)state.setValue((Property)ageProp, (Comparable)Integer.valueOf(age + 1));
                level.setBlockAndUpdate(pos, state);
            }
        }
    }

    public abstract RegistryPlant getPlant();

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        IntegerProperty ageProp = this.getPlant().getAgeProperty();
        if (ageProp != null) {
            builder.add(new Property[]{ageProp});
        }
    }

    public float getSpeedFactor() {
        float modifier = TFCConfig.SERVER.plantsMovementModifier.get().floatValue();
        return Helpers.lerp(modifier, this.speedFactor, 1.0f);
    }

    protected int getMaxAgeValue() {
        IntegerProperty ageProp = this.getPlant().getAgeProperty();
        if (ageProp == null) {
            return 0;
        }
        return ageProp.getPossibleValues().stream().max(Comparator.naturalOrder()).orElse(0);
    }
}

