/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.BiPredicate;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.rock.LooseRockBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.jetbrains.annotations.Nullable;

public final class PlantRegrowth {
    public static final BiPredicate<BlockState, BlockPos> DEFAULT_PLACEMENT_TEST = (s, p) -> s.isAir() || s.getBlock() instanceof DeadCropBlock;

    public static boolean canSpread(Level level, RandomSource random, BlockPos pos) {
        return (double)random.nextFloat() < TFCConfig.SERVER.plantSpreadChance.get() && Calendars.get((LevelReader)level).getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, level)).getSeason() != Season.WINTER;
    }

    @Nullable
    public static BlockPos spreadSelf(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int selfSpreadRange, int radius, int maxPlants) {
        return PlantRegrowth.spreadSelf(state, level, pos, random, selfSpreadRange, radius, maxPlants, (s, p) -> Helpers.isBlock(s, TFCTags.Blocks.NATURAL_REGROWING_PLANTS), DEFAULT_PLACEMENT_TEST);
    }

    @Nullable
    public static BlockPos spreadSelf(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int selfSpreadRange, int radius, int maxPlants, BiPredicate<BlockState, BlockPos> occlusionTest, BiPredicate<BlockState, BlockPos> placementTest) {
        BlockPos newPos = pos.offset(Mth.nextInt((RandomSource)random, (int)0, (int)selfSpreadRange), 0, Mth.nextInt((RandomSource)random, (int)0, (int)selfSpreadRange));
        if (newPos.equals((Object)pos)) {
            newPos = pos.offset(Mth.nextInt((RandomSource)random, (int)1, (int)selfSpreadRange), 0, Mth.nextInt((RandomSource)random, (int)1, (int)selfSpreadRange));
        }
        if ((state = FluidHelpers.fillWithFluid(state, level.getFluidState(newPos).getType())) != null && placementTest.test(level.getBlockState(newPos), newPos) && state.canSurvive((LevelReader)level, newPos)) {
            int plants = 0;
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    cursor.setWithOffset((Vec3i)newPos, x, 0, z);
                    if (!level.isLoaded((BlockPos)cursor)) {
                        return null;
                    }
                    if (!occlusionTest.test(level.getBlockState((BlockPos)cursor), (BlockPos)cursor) || plants++ <= maxPlants) continue;
                    return null;
                }
            }
            return newPos;
        }
        return null;
    }

    public static void placeRisingRock(ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState state;
        if ((double)random.nextFloat() > TFCConfig.SERVER.grassSpawningRocksChance.get() || Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level)).getSeason() != Season.SPRING || Climate.getAverageTemperature((Level)level, pos) > 8.0f || !level.isAreaLoaded(pos, 2) || PlantRegrowth.hasPlayerNearby(level, pos, 20)) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        if (WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)level.getSeed(), (long)6942069420L).nextInt(5) != 0) {
            return;
        }
        BlockState currentState = level.getBlockState(pos);
        boolean isInAir = currentState.isAir();
        boolean isInSelf = currentState.getBlock() instanceof LooseRockBlock;
        if (!isInSelf && !isInAir) {
            return;
        }
        if (isInAir) {
            ChunkData data = ChunkData.get((LevelReader)level, pos);
            state = data.getRockData().getRock(pos).loose().map(Block::defaultBlockState).orElse(null);
            if (state == null) {
                return;
            }
            if ((state = FluidHelpers.fillWithFluid(state, level.getFluidState(pos).getType())) == null || !state.canSurvive((LevelReader)level, pos)) {
                return;
            }
        } else if ((Integer)currentState.getValue((Property)LooseRockBlock.COUNT) < 3) {
            state = (BlockState)currentState.cycle((Property)LooseRockBlock.COUNT);
        } else {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                cursor.setWithOffset((Vec3i)pos, x, 0, z);
                if (!(level.getBlockState((BlockPos)cursor).getBlock() instanceof LooseRockBlock)) continue;
                return;
            }
        }
        level.setBlockAndUpdate(pos, state);
    }

    private static boolean hasPlayerNearby(ServerLevel level, BlockPos pos, int range) {
        for (ServerPlayer player : level.players()) {
            if (!(player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)(range * range))) continue;
            return true;
        }
        return false;
    }
}

