/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.WaterPlantBlock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class RotatableWaterPlantBlock
extends WaterPlantBlock {
    public static final BooleanProperty OPEN = TFCBlockStateProperties.OPEN;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    protected static final VoxelShape NORTH_SHAPE = RotatableWaterPlantBlock.box((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = RotatableWaterPlantBlock.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0);
    protected static final VoxelShape WEST_SHAPE = RotatableWaterPlantBlock.box((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape EAST_SHAPE = RotatableWaterPlantBlock.box((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0);
    protected static final VoxelShape UP_SHAPE = RotatableWaterPlantBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    protected static final VoxelShape DOWN_SHAPE = RotatableWaterPlantBlock.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH_SHAPE, (Object)Direction.SOUTH, (Object)SOUTH_SHAPE, (Object)Direction.WEST, (Object)WEST_SHAPE, (Object)Direction.EAST, (Object)EAST_SHAPE, (Object)Direction.UP, (Object)UP_SHAPE, (Object)Direction.DOWN, (Object)DOWN_SHAPE);

    public static RotatableWaterPlantBlock create(final RegistryPlant plant, final FluidProperty fluid, ExtendedProperties properties) {
        return new RotatableWaterPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected RotatableWaterPlantBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, false);
        }
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !Helpers.isBlock(facingState, TFCTags.Blocks.ANEMONE_PLANTABLE_ON)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState attachedState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        return Helpers.isBlock(attachedState, TFCTags.Blocks.ANEMONE_PLANTABLE_ON);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Fluid fluid = context.getLevel().getFluidState(pos).getType();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        if (this.getFluidProperty().canContain(fluid)) {
            state = (BlockState)state.setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid));
            if (fluid == TFCFluids.SALT_WATER.getSource()) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{FACING}).add(new Property[]{OPEN}));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide && level.getFluidState(pos).getType().isSame((Fluid)TFCFluids.SALT_WATER.getSource())) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.scheduleTick(pos, (Block)this, 150);
        }
    }
}

