/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;

public class TFCBushBlock
extends BushBlock
implements IForgeBlockExtension {
    private final ExtendedProperties properties;

    public TFCBushBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return this.mayPlaceOn(level.getBlockState(below), (BlockGetter)level, below);
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(state.getBlock(), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return this.fakeBlockCodec();
    }
}

