/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.WaterPlantBlock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCSeagrassBlock
extends WaterPlantBlock {
    protected static final VoxelShape GRASS_SHAPE = TFCSeagrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHORTER_GRASS_SHAPE = TFCSeagrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    protected static final VoxelShape SHORT_GRASS_SHAPE = TFCSeagrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    protected static final VoxelShape SHORTEST_GRASS_SHAPE = TFCSeagrassBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);

    public static TFCSeagrassBlock create(final RegistryPlant plant, final FluidProperty fluid, BlockBehaviour.Properties properties) {
        return new TFCSeagrassBlock(ExtendedProperties.of(properties)){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }

            @Override
            public FluidProperty getFluidProperty() {
                return fluid;
            }
        };
    }

    protected TFCSeagrassBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        IntegerProperty ageProp = this.getPlant().getAgeProperty();
        if (ageProp == null) {
            return GRASS_SHAPE;
        }
        return switch ((Integer)state.getValue((Property)ageProp)) {
            case 0 -> SHORTEST_GRASS_SHAPE;
            case 1 -> SHORTER_GRASS_SHAPE;
            case 2 -> SHORT_GRASS_SHAPE;
            default -> GRASS_SHAPE;
        };
    }

    public float getMaxHorizontalOffset() {
        return super.getMaxHorizontalOffset();
    }
}

