/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.common.blocks.plant.ShortGrassBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class TFCTallGrassBlock
extends ShortGrassBlock
implements ITallPlant {
    protected static final EnumProperty<ITallPlant.Part> PART = TFCBlockStateProperties.TALL_PLANT_PART;
    protected static final VoxelShape PLANT_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHORTER_PLANT_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);

    public static TFCTallGrassBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new TFCTallGrassBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected TFCTallGrassBlock(ExtendedProperties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)ITallPlant.Part.LOWER)));
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos newPos;
        super.randomTick(state, level, pos, random);
        if (PlantRegrowth.canSpread((Level)level, random, pos) && state.getValue(PART) == ITallPlant.Part.LOWER && (newPos = PlantRegrowth.spreadSelf(state, level, pos, random, 2, 2, 4)) != null && PlantRegrowth.DEFAULT_PLACEMENT_TEST.test(level.getBlockState(newPos.above()), newPos.above())) {
            this.placeTwoHalves((LevelAccessor)level, newPos, 2, random);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        ITallPlant.Part part = (ITallPlant.Part)((Object)state.getValue(PART));
        if (facing.getAxis() != Direction.Axis.Y || part == ITallPlant.Part.LOWER != (facing == Direction.UP) || facingState.getBlock() == this && facingState.getValue(PART) != part) {
            return part == ITallPlant.Part.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue(PART) == ITallPlant.Part.LOWER) {
            return super.canSurvive(state, level, pos);
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return super.canSurvive(state, level, pos);
        }
        return blockstate.getBlock() == this && blockstate.getValue(PART) == ITallPlant.Part.LOWER;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        return pos.getY() < context.getLevel().getMaxBuildHeight() - 1 && context.getLevel().getBlockState(pos.above()).canBeReplaced(context) ? super.getStateForPlacement(context) : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{PART}));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlockAndUpdate(pos.above(), (BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)ITallPlant.Part.UPPER)));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                BlockPos blockpos;
                BlockState blockstate;
                if (state.getValue(PART) == ITallPlant.Part.UPPER && (blockstate = level.getBlockState(blockpos = pos.below())).getBlock() == state.getBlock() && blockstate.getValue(PART) == ITallPlant.Part.LOWER) {
                    level.setBlock(blockpos, level.getFluidState(blockpos).createLegacyBlock(), 35);
                    level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                }
            } else {
                TFCTallGrassBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return state;
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity tile, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), tile, stack);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ITallPlant.Part part = (ITallPlant.Part)((Object)state.getValue(PART));
        if (part == ITallPlant.Part.LOWER) {
            return PLANT_SHAPE;
        }
        return SHORTER_PLANT_SHAPE;
    }

    public void placeTwoHalves(LevelAccessor level, BlockPos pos, int flags, RandomSource random) {
        IntegerProperty ageProp = this.getPlant().getAgeProperty();
        BlockState lower = (BlockState)this.defaultBlockState().setValue(TFCBlockStateProperties.TALL_PLANT_PART, (Comparable)((Object)ITallPlant.Part.LOWER));
        BlockState upper = (BlockState)this.defaultBlockState().setValue(TFCBlockStateProperties.TALL_PLANT_PART, (Comparable)((Object)ITallPlant.Part.UPPER));
        if (ageProp != null) {
            int maxAge = this.getMaxAgeValue();
            int age = maxAge > 0 ? random.nextInt(maxAge) + 1 : 0;
            lower = Helpers.setProperty(lower, ageProp, age);
            upper = Helpers.setProperty(upper, ageProp, age);
        }
        level.setBlock(pos, lower, flags);
        level.setBlock(pos.above(), upper, flags);
    }
}

