/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.coral.CoralWallFanBlock;
import net.dries007.tfc.common.blocks.plant.coral.LivingCoralPlantBlock;
import net.dries007.tfc.common.blocks.plant.coral.LivingCoralWallFanBlock;
import net.dries007.tfc.common.blocks.plant.coral.TFCCoralPlantBlock;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public enum Coral {
    TUBE(MapColor.COLOR_BLUE),
    BRAIN(MapColor.COLOR_PINK),
    BUBBLE(MapColor.COLOR_PURPLE),
    FIRE(MapColor.COLOR_RED),
    HORN(MapColor.COLOR_YELLOW);

    private final MapColor color;

    private Coral(MapColor color) {
        this.color = color;
    }

    public static enum BlockType {
        DEAD_CORAL((color, type) -> new TFCCoralPlantBlock(TFCCoralPlantBlock.BIG_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().noCollission().instabreak())),
        CORAL((color, type) -> new LivingCoralPlantBlock(TFCCoralPlantBlock.BIG_SHAPE, (Supplier<? extends Block>)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL), BlockBehaviour.Properties.of().mapColor(color.color).noCollission().instabreak().sound(SoundType.WET_GRASS))),
        DEAD_CORAL_FAN((color, type) -> new TFCCoralPlantBlock(TFCCoralPlantBlock.SMALL_SHAPE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().noCollission().instabreak())),
        CORAL_FAN((color, type) -> new LivingCoralPlantBlock(TFCCoralPlantBlock.SMALL_SHAPE, (Supplier<? extends Block>)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_FAN), BlockBehaviour.Properties.of().mapColor(color.color).noCollission().instabreak().sound(SoundType.WET_GRASS))),
        DEAD_CORAL_WALL_FAN((color, type) -> new CoralWallFanBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).requiresCorrectToolForDrops().noCollission().instabreak().lootFrom((Supplier)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_FAN)))),
        CORAL_WALL_FAN((color, type) -> new LivingCoralWallFanBlock((Supplier<? extends Block>)TFCBlocks.CORAL.get(color).get((Object)DEAD_CORAL_WALL_FAN), BlockBehaviour.Properties.of().mapColor(color.color).noCollission().instabreak().sound(SoundType.WET_GRASS).lootFrom((Supplier)TFCBlocks.CORAL.get(color).get((Object)CORAL_FAN))));

        private final BiFunction<Coral, BlockType, ? extends Block> factory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;

        private BlockType(BiFunction<Coral, BlockType, ? extends Block> factory) {
            this(factory, BlockItem::new);
        }

        private BlockType(BiFunction<Coral, BlockType, ? extends Block> factory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.factory = factory;
            this.blockItemFactory = blockItemFactory;
        }

        public boolean needsItem() {
            return this == DEAD_CORAL || this == CORAL;
        }

        public Supplier<Block> create(Coral color) {
            return () -> this.factory.apply(color, this);
        }

        @Nullable
        public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
            return this.needsItem() ? block -> this.blockItemFactory.apply((Block)block, properties) : null;
        }
    }
}

