/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.coral;

import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCSeaPickleBlock
extends Block
implements IFluidLoggable {
    public static final IntegerProperty PICKLES = BlockStateProperties.PICKLES;
    public static final FluidProperty FLUID = TFCBlockStateProperties.SALT_WATER;
    protected static final VoxelShape ONE_AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    protected static final VoxelShape TWO_AABB = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape THREE_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape FOUR_AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);

    public static boolean isDead(BlockState state) {
        FluidProperty property = ((TFCSeaPickleBlock)state.getBlock()).getFluidProperty();
        return state.getValue((Property)property) == property.keyFor(Fluids.EMPTY);
    }

    public TFCSeaPickleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PICKLES, (Comparable)Integer.valueOf(1)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        if (Helpers.isBlock(blockstate, this)) {
            return (BlockState)blockstate.setValue((Property)PICKLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.getValue((Property)PICKLES) + 1)));
        }
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == TFCFluids.SALT_WATER.getSource();
        return (BlockState)this.defaultBlockState().setValue((Property)this.getFluidProperty(), (Comparable)(flag ? this.getFluidProperty().keyFor((Fluid)TFCFluids.SALT_WATER.getSource()) : this.getFluidProperty().keyFor(Fluids.EMPTY)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PICKLES, this.getFluidProperty()});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return useContext.getItemInHand().getItem() == this.asItem() && (Integer)state.getValue((Property)PICKLES) < 4 || super.canBeReplaced(state, useContext);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return this.mayPlaceOn(level.getBlockState(blockpos), (BlockGetter)level, blockpos);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)PICKLES)) {
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
            default -> ONE_AABB;
        };
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.getCollisionShape(level, pos).getFaceShape(Direction.UP).isEmpty() || state.isFaceSturdy(level, pos, Direction.UP);
    }
}

