/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.BananaPlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.BananaSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.WaterloggedBerryBushBlock;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.PlantableInfo;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public final class FruitBlocks {
    private static final Lifecycle[] CRANBERRY_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT};
    private static final Lifecycle[] BANANA_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT};

    public static WaterloggedBerryBushBlock createCranberry() {
        return new WaterloggedBerryBushBlock(ExtendedProperties.of(MapColor.PLANT).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.SWEET_BERRY_BUSH).blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), TFCItems.FOOD.get((Object)Food.CRANBERRY), CRANBERRY_STAGES, ClimateRanges.CRANBERRY_BUSH);
    }

    public static BlockItem createCranberryItem(Block block) {
        return new BushBlockItem(block, ClimateRanges.CRANBERRY_BUSH, CRANBERRY_STAGES);
    }

    public static Block createBananaSapling() {
        return new BananaSaplingBlock(ExtendedProperties.of(MapColor.PLANT).noCollission().randomTicks().strength(0.0f).sound(SoundType.GRASS).blockEntity(TFCBlockEntities.TICK_COUNTING_PLANT).flammableLikeLeaves(), BANANA_STAGES, TFCBlocks.BANANA_PLANT, TFCConfig.SERVER.bananaSaplingGrowthTicks);
    }

    public static BlockItem createBananaSaplingItem(Block block) {
        return new FruitTreeSaplingItem(block, ClimateRanges.BANANA_PLANT, BANANA_STAGES);
    }

    public static Block createPottedBananaSapling() {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, TFCBlocks.BANANA_SAPLING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ACACIA_SAPLING));
    }

    public static Block createBananaPlant() {
        return new BananaPlantBlock(ExtendedProperties.of(MapColor.PLANT).strength(0.5f).sound(SoundType.GRASS).randomTicks().noOcclusion().forceSolidOn().blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves().cloneItem(TFCBlocks.BANANA_SAPLING), TFCItems.FOOD.get((Object)Food.BANANA), BANANA_STAGES);
    }

    private static class BushBlockItem
    extends BlockItem
    implements PlantableInfo {
        private final Supplier<ClimateRange> climateRange;
        private final List<Lifecycle> stages;

        private BushBlockItem(Block block, Supplier<ClimateRange> range, Lifecycle[] stages) {
            super(block, new Item.Properties());
            this.climateRange = range;
            this.stages = List.of(stages);
        }

        @Override
        @Nullable
        public ClimateRange getClimateRangeInfo() {
            return this.climateRange.get();
        }

        @Override
        @Nullable
        public List<Lifecycle> getLifecycleInfo() {
            return this.stages;
        }
    }

    private static class FruitTreeSaplingItem
    extends BlockItem
    implements PlantableInfo {
        private final Supplier<ClimateRange> climateRange;
        private final List<Lifecycle> stages;
        private final LongSupplier ticksToGrow;

        private FruitTreeSaplingItem(Block block, Supplier<ClimateRange> climateRange, Lifecycle[] lifecycle) {
            super(block, new Item.Properties());
            this.climateRange = climateRange;
            this.stages = List.of(lifecycle);
            if (block instanceof FruitTreeSaplingBlock) {
                FruitTreeSaplingBlock sapling = (FruitTreeSaplingBlock)block;
                this.ticksToGrow = sapling::getTicksToGrow;
            } else {
                this.ticksToGrow = () -> -1L;
            }
        }

        @Override
        @Nullable
        public ClimateRange getClimateRangeInfo() {
            return this.climateRange.get();
        }

        @Override
        @Nullable
        public List<Lifecycle> getLifecycleInfo() {
            return this.stages;
        }

        @Override
        public int getGrowthTimeInfo() {
            return (int)this.ticksToGrow.getAsLong();
        }
    }

    public static enum Tree implements StringRepresentable
    {
        CHERRY(Food.CHERRY, 8, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}, new Color(251, 135, 255).getRGB()),
        GREEN_APPLE(Food.GREEN_APPLE, 10, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(252, 171, 255).getRGB()),
        LEMON(Food.LEMON, 8, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(215, 137, 217).getRGB()),
        OLIVE(Food.OLIVE, 12, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(206, 198, 207).getRGB()),
        ORANGE(Food.ORANGE, 7, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(251, 242, 252).getRGB()),
        PEACH(Food.PEACH, 11, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}, new Color(230, 126, 188).getRGB()),
        PLUM(Food.PLUM, 8, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(165, 70, 189).getRGB()),
        RED_APPLE(Food.RED_APPLE, 10, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, new Color(252, 171, 255).getRGB());

        private final Food product;
        private final Lifecycle[] stages;
        private final String serializedName;
        private final int defaultTicksToGrow;
        private final int floweringLeavesColor;

        private Tree(Food product, int daysToGrow, Lifecycle[] stages, int floweringLeavesColor) {
            this.product = product;
            this.stages = stages;
            this.serializedName = this.name().toLowerCase(Locale.ROOT);
            this.defaultTicksToGrow = daysToGrow * 24000;
            this.floweringLeavesColor = floweringLeavesColor;
        }

        public Block createSapling() {
            return new FruitTreeSaplingBlock(ExtendedProperties.of(MapColor.PLANT).noCollission().randomTicks().strength(0.0f).sound(SoundType.GRASS).blockEntity(TFCBlockEntities.TICK_COUNTING_PLANT).flammableLikeLeaves(), (Supplier<? extends Block>)TFCBlocks.FRUIT_TREE_GROWING_BRANCHES.get((Object)this), TFCConfig.SERVER.fruitSaplingGrowthTicks.get((Object)this), (Supplier<ClimateRange>)ClimateRanges.FRUIT_TREES.get((Object)this), this.stages);
        }

        public Block createPottedSapling() {
            return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, (Supplier)TFCBlocks.FRUIT_TREE_SAPLINGS.get((Object)this), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ACACIA_SAPLING));
        }

        public Block createLeaves() {
            return new FruitTreeLeavesBlock(ExtendedProperties.of().mapColor(FruitTreeLeavesBlock::getMapColor).strength(0.5f).sound(SoundType.GRASS).randomTicks().noOcclusion().blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier<ClimateRange>)ClimateRanges.FRUIT_TREES.get((Object)this), this.floweringLeavesColor);
        }

        public Block createBranch() {
            return new FruitTreeBranchBlock(ExtendedProperties.of(MapColor.WOOD).sound(SoundType.SCAFFOLDING).randomTicks().strength(1.0f).pushReaction(PushReaction.DESTROY).flammableLikeLogs(), (Supplier<ClimateRange>)ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public Block createGrowingBranch() {
            return new GrowingFruitTreeBranchBlock(ExtendedProperties.of(MapColor.WOOD).sound(SoundType.SCAFFOLDING).randomTicks().strength(1.0f).pushReaction(PushReaction.DESTROY).blockEntity(TFCBlockEntities.TICK_COUNTING_PLANT).flammableLikeLogs().cloneEmpty(), (Supplier<? extends Block>)TFCBlocks.FRUIT_TREE_BRANCHES.get((Object)this), (Supplier<? extends Block>)TFCBlocks.FRUIT_TREE_LEAVES.get((Object)this), (Supplier<ClimateRange>)ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public BlockItem createSaplingItem(Block block) {
            return new FruitTreeSaplingItem(block, (Supplier<ClimateRange>)ClimateRanges.FRUIT_TREES.get((Object)this), this.stages);
        }

        public int defaultTicksToGrow() {
            return this.defaultTicksToGrow;
        }

        public String getSerializedName() {
            return this.serializedName;
        }
    }

    public static enum StationaryBush {
        SNOWBERRY(Food.SNOWBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        BUNCHBERRY(Food.BUNCHBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        GOOSEBERRY(Food.GOOSEBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        CLOUDBERRY(Food.CLOUDBERRY, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        STRAWBERRY(Food.STRAWBERRY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY),
        WINTERGREEN_BERRY(Food.WINTERGREEN_BERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING);

        private final Food product;
        private final Lifecycle[] stages;

        private StationaryBush(Food product, Lifecycle ... stages) {
            this.product = product;
            this.stages = stages;
        }

        public Block create() {
            return new StationaryBerryBushBlock(ExtendedProperties.of(MapColor.PLANT).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.SWEET_BERRY_BUSH).blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier<ClimateRange>)ClimateRanges.STATIONARY_BUSHES.get((Object)this));
        }

        public BlockItem createItem(Block block) {
            return new BushBlockItem(block, (Supplier<ClimateRange>)ClimateRanges.STATIONARY_BUSHES.get((Object)this), this.stages);
        }
    }

    public static enum SpreadingBush {
        BLACKBERRY(Food.BLACKBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 4),
        RASPBERRY(Food.RASPBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3),
        BLUEBERRY(Food.BLUEBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 2),
        ELDERBERRY(Food.ELDERBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3);

        private final Food product;
        private final Lifecycle[] stages;
        private final int maxHeight;

        private SpreadingBush(Food product, Lifecycle[] stages, int maxHeight) {
            this.product = product;
            this.stages = stages;
            this.maxHeight = maxHeight;
        }

        public Block createBush() {
            return new SpreadingBushBlock(ExtendedProperties.of(MapColor.PLANT).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.SWEET_BERRY_BUSH).blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier<? extends Block>)TFCBlocks.SPREADING_CANES.get((Object)this), this.maxHeight, (Supplier<ClimateRange>)ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }

        public Block createCane() {
            return new SpreadingCaneBlock(ExtendedProperties.of(MapColor.PLANT).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.SWEET_BERRY_BUSH).blockEntity(TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier<? extends Block>)TFCBlocks.SPREADING_BUSHES.get((Object)this), this.maxHeight, (Supplier<ClimateRange>)ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }

        public BlockItem createItem(Block block) {
            return new BushBlockItem(block, (Supplier<ClimateRange>)ClimateRanges.SPREADING_BUSHES.get((Object)this), this.stages);
        }
    }
}

