/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpreadingBushBlock
extends StationaryBerryBushBlock
implements IForgeBlockExtension,
HoeOverlayBlock {
    protected final Supplier<? extends Block> companion;
    protected final int maxHeight;

    public SpreadingBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<? extends Block> companion, int maxHeight, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, stages, climateRange);
        this.companion = companion;
        this.maxHeight = maxHeight;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public Block getCane() {
        return this.companion.get();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.getValue((Property)STAGE) == 2 ? Shapes.block() : PLANT_SHAPE;
    }

    @Override
    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos climatePos;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity plant = (BerryBushBlockEntity)blockEntity;
            climatePos = plant.getStemPos();
        } else {
            climatePos = pos;
        }
        int hydration = SpreadingBushBlock.getFruitBushHydrationFromRootPos((Level)level, climatePos);
        float temp = Climate.getAverageTemperature((Level)level, climatePos);
        if (((ClimateRange)this.climateRange.get()).checkBoth(hydration, temp, false)) {
            this.tick(state, level, pos, random);
        } else {
            level.setBlockAndUpdate(pos, this.getDeadState(state));
        }
    }

    @Override
    protected void growAndPropagate(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int cycles, int growthsRemaining) {
        int originalStage = (Integer)state.getValue((Property)STAGE);
        if (originalStage == 0) {
            BlockState newState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1));
            this.placeBlockAndResetCounter(level, pos, newState, cycles, growthsRemaining);
            return;
        }
        if (originalStage == 1) {
            Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            BlockPos adjacentPos = pos.relative(dir);
            if (level.getBlockState(adjacentPos).isEmpty()) {
                this.placeNewBushAndResetCounters(level, adjacentPos, pos, (BlockState)((BlockState)this.companion.get().defaultBlockState().setValue((Property)SpreadingCaneBlock.FACING, (Comparable)dir)).setValue((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.getValue((Property)LIFECYCLE))))), cycles, growthsRemaining);
                this.maybeStopGrowing(level, pos, state, random);
            } else {
                BlockPos abovePos = pos.above();
                if (level.isEmptyBlock(abovePos) && SpreadingBushBlock.distanceToGround((Level)level, pos, this.maxHeight) < this.maxHeight) {
                    ((BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1))).setValue((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.getValue((Property)LIFECYCLE)))));
                    this.placeNewBushAndResetCounters(level, abovePos, pos, state, cycles, growthsRemaining);
                    level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)), 3);
                }
            }
        }
    }

    private void maybeStopGrowing(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if (random.nextBoolean()) {
            int count = 0;
            for (BlockPos target : BlockPos.betweenClosed((BlockPos)pos.offset(-2, 0, -2), (BlockPos)pos.offset(2, 1, 2))) {
                if (level.getBlockState(target).getBlock() != this || ++count <= 10) continue;
                return;
            }
        }
        level.setBlock(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(2)), 3);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        return this.mayPlaceOn(belowState, (BlockGetter)level, belowPos) || belowState.getBlock() == this && (Integer)belowState.getValue((Property)STAGE) != 0;
    }

    @Override
    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return Helpers.isBlock(state, TFCTags.Blocks.SPREADING_FRUIT_GROWS_ON);
    }

    /*
     * Unable to fully structure code
     */
    private void placeNewBushAndResetCounters(ServerLevel level, BlockPos newPos, BlockPos oldPos, BlockState state, int cycles, int growths) {
        level.setBlockAndUpdate(newPos, state);
        var9_7 = level.getBlockEntity(oldPos);
        if (!(var9_7 instanceof BerryBushBlockEntity)) ** GOTO lbl-1000
        sourceBush = (BerryBushBlockEntity)var9_7;
        var9_7 = level.getBlockEntity(newPos);
        if (var9_7 instanceof BerryBushBlockEntity) {
            newBush = (BerryBushBlockEntity)var9_7;
            sourceBush.resetCounter();
            sourceBush.increaseCounter((long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue() * (long)cycles);
            sourceBush.setGrowthsRemaining(growths);
            newBush.resetCounter();
            newBush.increaseCounter((long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue() * (long)cycles);
            newBush.setGrowthsRemaining(growths);
            newBush.setStemPos(sourceBush.getStemPos());
        } else lbl-1000:
        // 2 sources

        {
            TerraFirmaCraft.LOGGER.error("Failed to update growing berry bush block entity at: {}", (Object)oldPos);
        }
        level.getBlockState(oldPos).tick(level, oldPos, level.random);
        level.getBlockState(newPos).tick(level, newPos, level.random);
    }
}

