/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StationaryBerryBushBlock
extends SeasonalPlantBlock
implements HoeOverlayBlock {
    private static final VoxelShape HALF_PLANT = StationaryBerryBushBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);

    public StationaryBerryBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] lifecycle, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange, productItem, lifecycle);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIFECYCLE, (Comparable)((Object)(this.getLifecycleForCurrentMonth(context.getLevel(), context.getClickedPos()).active() ? Lifecycle.HEALTHY : Lifecycle.DORMANT)));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return HALF_PLANT;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int hydration = StationaryBerryBushBlock.getFruitBushHydration((Level)level, pos);
        float temp = Climate.getAverageTemperature((Level)level, pos);
        if (((ClimateRange)this.climateRange.get()).checkBoth(hydration, temp, false)) {
            this.tick(state, level, pos, random);
        } else {
            level.setBlockAndUpdate(pos, this.getDeadState(state));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int maxCycles;
        BerryBushBlockEntity counter;
        BlockEntity blockEntity;
        Block block = state.getBlock();
        if (!(block instanceof SeasonalPlantBlock)) {
            return;
        }
        SeasonalPlantBlock plant = (SeasonalPlantBlock)block;
        plant.onUpdate((Level)level, pos, state);
        if (((Lifecycle)((Object)level.getBlockState(pos).getValue((Property)LIFECYCLE))).active() && (blockEntity = level.getBlockEntity(pos)) instanceof BerryBushBlockEntity && (counter = (BerryBushBlockEntity)blockEntity).getGrowthsRemaining() > 0 && (maxCycles = (int)(counter.getTicksSinceUpdate() / (long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue())) >= 1) {
            long previousTick;
            maxCycles = Math.min(maxCycles, 8);
            int cycles = 0;
            int daysInMonth = Calendars.SERVER.getCalendarDaysInMonth();
            long currentTick = Calendars.SERVER.getTicks();
            if (currentTick - (previousTick = counter.getLastUpdateTick()) >= 24000L * (long)daysInMonth * 8L) {
                cycles = 8;
            } else {
                Lifecycle lifecycle;
                Month month;
                long simulatedCalendarTick;
                long simulatedTick;
                boolean checkReverseDirection = false;
                for (simulatedTick = previousTick; cycles < maxCycles && simulatedTick < currentTick; ++cycles, simulatedTick += (long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue()) {
                    simulatedCalendarTick = Calendars.SERVER.getCalendarTickFromOffset(simulatedTick - currentTick);
                    month = Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level), simulatedCalendarTick, daysInMonth);
                    lifecycle = this.getLifecycleForMonth(month);
                    if (lifecycle != Lifecycle.DORMANT) {
                        continue;
                    }
                    checkReverseDirection = true;
                    break;
                }
                if (checkReverseDirection) {
                    for (simulatedTick = currentTick; cycles < maxCycles && simulatedTick > previousTick; ++cycles, simulatedTick -= (long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue()) {
                        simulatedCalendarTick = Calendars.SERVER.getCalendarTickFromOffset(simulatedTick - currentTick);
                        month = Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level), simulatedCalendarTick, daysInMonth);
                        lifecycle = this.getLifecycleForMonth(month);
                        if (lifecycle == Lifecycle.DORMANT) break;
                    }
                }
            }
            counter.resetCounter();
            if (cycles > 0) {
                this.growAndPropagate(state, level, pos, rand, cycles - 1, counter.getGrowthsRemaining() - 1);
            }
        }
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, Consumer<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            ClimateRange range = (ClimateRange)this.climateRange.get();
            BlockPos sourcePos = bush.getStemPos().below();
            int hydration = StationaryBerryBushBlock.getFruitBushHydration(level, pos);
            text.accept(FarmlandBlock.getHydrationTooltip(range, false, hydration));
            text.accept(FarmlandBlock.getAverageTemperatureTooltip(level, sourcePos, range, false));
        }
    }

    protected void growAndPropagate(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, int cycles, int growthsRemaining) {
        int oldStage = (Integer)state.getValue((Property)STAGE);
        if (oldStage < 2) {
            BlockState newState = (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)STAGE) + 1));
            this.placeBlockAndResetCounter(level, pos, newState, cycles, growthsRemaining);
            return;
        }
        int count = 0;
        for (BlockPos target : BlockPos.betweenClosed((BlockPos)pos.offset(-2, -1, -2), (BlockPos)pos.offset(2, 1, 2))) {
            if (level.getBlockState(target).getBlock() != this || ++count <= 3) continue;
            return;
        }
        BlockPos.MutableBlockPos cursor = pos.mutable();
        for (int tries = 0; tries < 3; ++tries) {
            cursor.setWithOffset((Vec3i)pos, Helpers.triangle(random, 3), 0, Helpers.triangle(random, 3));
            BlockPos newPos = level.getHeightmapPos(Heightmap.Types.OCEAN_FLOOR, (BlockPos)cursor);
            BlockState placementState = this.getNewState((Level)level, newPos);
            if (!this.canPlaceNewBushAt((Level)level, newPos, placementState)) continue;
            this.placeBlockAndResetCounter(level, newPos, placementState, cycles, growthsRemaining - random.nextInt(1, 3));
            return;
        }
    }

    protected void placeBlockAndResetCounter(ServerLevel level, BlockPos pos, BlockState state, int cycles, int growths) {
        level.setBlock(pos, state, 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BerryBushBlockEntity) {
            BerryBushBlockEntity bush = (BerryBushBlockEntity)blockEntity;
            bush.resetCounter();
            bush.increaseCounter((long)TFCConfig.SERVER.berryBushGrowthTicks.get().intValue() * (long)cycles);
            bush.setGrowthsRemaining(growths);
        } else {
            TerraFirmaCraft.LOGGER.error("Failed to update propagated berry bush block entity at: {}", (Object)pos);
        }
        level.getBlockState(pos).tick(level, pos, level.random);
    }

    protected BlockState getNewState(Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(0))).setValue((Property)LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY));
    }

    protected boolean canPlaceNewBushAt(Level level, BlockPos pos, BlockState placementState) {
        return level.isEmptyBlock(pos) && placementState.canSurvive((LevelReader)level, pos);
    }

    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()).defaultBlockState().setValue((Property)STAGE, (Comparable)((Integer)state.getValue((Property)STAGE)));
    }
}

