/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.rotation;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrankshaftBlock
extends HorizontalDirectionalBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.CRANKSHAFT_PART;
    private static final VoxelShape[] BASE_SHAPES = Helpers.computeHorizontalShapes(dir -> Shapes.or((VoxelShape)Helpers.rotateShape(dir, 0.0, 0.0, 4.0, 16.0, 2.0, 12.0), (VoxelShape)Helpers.rotateShape(dir, 0.0, 2.0, 4.0, 4.0, 12.0, 12.0)));
    private static final VoxelShape[] SHAFT_SHAPES = Helpers.computeHorizontalShapes(dir -> Helpers.rotateShape(dir, 0.0, 7.0, 8.0, 16.0, 9.0, 10.0));
    private static final TagKey<Item> STEEL_RODS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)Helpers.resourceLocation("c", "rods/steel"));
    private final ExtendedProperties properties;

    public CrankshaftBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(PART, (Comparable)((Object)Part.BASE)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockPos partnerPos;
        BlockState stateAt;
        ItemStack held = player.getItemInHand(hand);
        if (state.getValue(PART) == Part.BASE && Helpers.isItem(held.getItem(), STEEL_RODS) && (stateAt = level.getBlockState(partnerPos = this.getPartnerPos(pos, state))).canBeReplaced() && stateAt.getFluidState().isEmpty()) {
            level.setBlockAndUpdate(partnerPos, (BlockState)state.setValue(PART, (Comparable)((Object)Part.SHAFT)));
            if (!player.isCreative()) {
                held.shrink(1);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (state.getValue(PART) == Part.SHAFT && facingPos.equals((Object)this.getPartnerPos(currentPos, state))) {
            return facingState.getBlock() == this && facingState.getValue(FACING) == state.getValue(FACING) ? state : Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int index = ((Direction)state.getValue(FACING)).get2DDataValue();
        return state.getValue(PART) == Part.BASE ? BASE_SHAPES[index] : SHAFT_SHAPES[(index + 3) % 4];
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return this.fakeBlockCodec();
    }

    private BlockPos getPartnerPos(BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue(FACING);
        return state.getValue(PART) == Part.BASE ? pos.relative(facing) : pos.relative(facing.getOpposite());
    }

    public static enum Part implements StringRepresentable
    {
        BASE,
        SHAFT;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

