/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.PlantRegrowth;
import net.dries007.tfc.common.blocks.soil.IDirtBlock;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class ConnectedGrassBlock
extends Block
implements IGrassBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty SNOWY = BlockStateProperties.SNOWY;
    private static final Map<Direction, BooleanProperty> PROPERTIES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.WEST, (Object)WEST, (Object)Direction.SOUTH, (Object)SOUTH);
    private final Supplier<? extends Block> dirt;
    @Nullable
    private final Supplier<? extends Block> path;
    @Nullable
    private final Supplier<? extends Block> farmland;

    public ConnectedGrassBlock(BlockBehaviour.Properties properties, Supplier<? extends Block> dirt, @Nullable Supplier<? extends Block> path, @Nullable Supplier<? extends Block> farmland) {
        super(properties.hasPostProcess(TFCBlocks::always));
        this.dirt = dirt;
        this.path = path;
        this.farmland = farmland;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    ConnectedGrassBlock(BlockBehaviour.Properties properties, SoilBlockType dirtType, RegistrySoilVariant variant) {
        this(properties, variant.getBlock(dirtType), variant.getBlock(SoilBlockType.GRASS_PATH), variant.getBlock(SoilBlockType.FARMLAND));
    }

    protected BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            return (BlockState)stateIn.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(Helpers.isBlock(facingState, (TagKey<Block>)BlockTags.SNOW)));
        }
        if (facing != Direction.DOWN) {
            return this.updateStateFromDirection((BlockGetter)level, currentPos, stateIn, facing);
        }
        return stateIn;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.scheduleTick(level, pos.relative(direction).above());
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.scheduleTick(level, pos.relative(direction).above());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    private void scheduleTick(Level level, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof IGrassBlock) {
            level.scheduleTick(pos, block, 0);
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canBeGrass(state, (LevelReader)level, pos)) {
            if (level.isAreaLoaded(pos, 3)) {
                level.setBlockAndUpdate(pos, this.getDirt());
            }
        } else {
            BlockPos.MutableBlockPos posAt = pos.mutable();
            posAt.move(0, 1, 0);
            if (level.getMaxLocalRawBrightness((BlockPos)posAt) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    IDirtBlock dirtBlock;
                    BlockState grassState;
                    posAt.setWithOffset((Vec3i)pos, random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    BlockState stateAt = level.getBlockState((BlockPos)posAt);
                    Block block = stateAt.getBlock();
                    if (!(block instanceof IDirtBlock) || !this.canPropagate(grassState = (dirtBlock = (IDirtBlock)block).getGrass(), (LevelReader)level, (BlockPos)posAt)) continue;
                    level.setBlockAndUpdate((BlockPos)posAt, this.updateStateFromNeighbors((BlockGetter)level, (BlockPos)posAt, grassState));
                }
            }
            PlantRegrowth.placeRisingRock(level, pos.above(), random);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        level.setBlock(pos, this.updateStateFromNeighbors((BlockGetter)level, pos, state), 2);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateUp = context.getLevel().getBlockState(context.getClickedPos().above());
        return (BlockState)this.updateStateFromNeighbors((BlockGetter)context.getLevel(), context.getClickedPos(), this.defaultBlockState()).setValue((Property)SNOWY, (Comparable)Boolean.valueOf(Helpers.isBlock(stateUp, Blocks.SNOW_BLOCK) || Helpers.isBlock(stateUp, Blocks.SNOW)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, SNOWY});
    }

    @Override
    public BlockState getDirt() {
        return this.dirt.get().defaultBlockState();
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility action, boolean simulate) {
        if (context.getItemInHand().canPerformAction(action)) {
            if (action == ItemAbilities.SHOVEL_FLATTEN && TFCConfig.SERVER.enableGrassPathCreation.get().booleanValue() && this.path != null) {
                return this.path.get().defaultBlockState();
            }
            if (action == ItemAbilities.HOE_TILL && this.farmland != null && TFCConfig.SERVER.enableFarmlandCreation.get().booleanValue() && HoeItem.onlyIfAirAbove((UseOnContext)context)) {
                return this.farmland.get().defaultBlockState();
            }
        }
        return null;
    }

    protected BlockState updateStateFromNeighbors(BlockGetter worldIn, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            state = this.updateStateFromDirection(worldIn, pos, state, direction);
        }
        return state;
    }

    protected BlockState updateStateFromDirection(BlockGetter worldIn, BlockPos pos, BlockState stateIn, Direction direction) {
        return (BlockState)stateIn.setValue((Property)PROPERTIES.get(direction), (Comparable)Boolean.valueOf(worldIn.getBlockState(pos.relative(direction).below()).getBlock() instanceof IGrassBlock));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return DirectionPropertyBlock.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return DirectionPropertyBlock.mirror(state, mirror);
    }
}

