/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.soil;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DryingBricksBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedDuffBlock;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.PathBlock;
import net.dries007.tfc.common.blocks.soil.TFCRootedDirtBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;

public enum SoilBlockType {
    DIRT((self, variant) -> new DirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.4f).sound(SoundType.GRAVEL), self.transform(), (RegistrySoilVariant)variant)),
    GRASS((self, variant) -> new ConnectedGrassBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).randomTicks().strength(1.8f).sound(SoundType.GRASS), self.transform(), (RegistrySoilVariant)variant)),
    DUFF((self, variant) -> new ConnectedDuffBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).randomTicks().strength(1.6f).sound(SoundType.GRASS), self.transform(), (RegistrySoilVariant)variant)),
    GRASS_PATH((self, variant) -> new PathBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.5f).sound(SoundType.GRASS), self.transform(), (RegistrySoilVariant)variant)),
    CLAY((self, variant) -> new DirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(1.5f).sound(SoundType.GRAVEL), self.transform(), (RegistrySoilVariant)variant)),
    CLAY_GRASS((self, variant) -> new ConnectedGrassBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).randomTicks().strength(1.8f).sound(SoundType.GRASS), self.transform(), (RegistrySoilVariant)variant)),
    CLAY_DUFF((self, variant) -> new ConnectedDuffBlock(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).randomTicks().strength(1.8f).sound(SoundType.GRASS), self.transform(), (RegistrySoilVariant)variant)),
    FARMLAND((self, variant) -> new FarmlandBlock(ExtendedProperties.of(MapColor.DIRT).strength(1.3f).sound(SoundType.GRAVEL).randomTicks().isViewBlocking(TFCBlocks::always).isSuffocating(TFCBlocks::always).blockEntity(TFCBlockEntities.FARMLAND).serverTicks(FarmlandBlockEntity::serverTick), (RegistrySoilVariant)variant)),
    ROOTED_DIRT((self, variant) -> new TFCRootedDirtBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).strength(2.0f).sound(SoundType.ROOTED_DIRT), self.transform(), (RegistrySoilVariant)variant)),
    COARSE_DIRT((self, variant) -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.GRAVEL).strength(1.6f).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops())),
    MUD((self, variant) -> new MudBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.MUD).strength(2.0f).speedFactor(0.8f).isRedstoneConductor(TFCBlocks::always).isViewBlocking(TFCBlocks::always).isSuffocating(TFCBlocks::always).instrument(NoteBlockInstrument.BASEDRUM))),
    MUD_BRICKS((self, variant) -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DIRT).sound(SoundType.MUD_BRICKS).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.6f))),
    DRYING_BRICKS((self, variant) -> new DryingBricksBlock(ExtendedProperties.of(MapColor.DIRT).noCollission().noOcclusion().instabreak().sound(SoundType.STEM).randomTicks().blockEntity(TFCBlockEntities.TICK_COUNTER), variant.mudBrick())),
    MUDDY_ROOTS((self, variant) -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUDDY_MANGROVE_ROOTS).strength(4.0f)));

    public static final SoilBlockType[] VALUES;
    private final BiFunction<SoilBlockType, RegistrySoilVariant, Block> factory;

    public static SoilBlockType valueOf(int i) {
        return i >= 0 && i < VALUES.length ? VALUES[i] : DIRT;
    }

    private SoilBlockType(BiFunction<SoilBlockType, RegistrySoilVariant, Block> factory) {
        this.factory = factory;
    }

    public Block create(RegistrySoilVariant variant) {
        return this.factory.apply(this, variant);
    }

    private SoilBlockType transform() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GRASS;
            case 1, 2, 3, 7, 8, 10, 11, 12, 13 -> DIRT;
            case 4 -> CLAY_GRASS;
            case 5, 6 -> CLAY;
            case 9 -> COARSE_DIRT;
        };
    }

    static {
        VALUES = SoilBlockType.values();
    }

    public static enum Variant implements RegistrySoilVariant
    {
        ENTISOL,
        ARIDISOL,
        OXISOL,
        FLUVISOL,
        ANDISOL,
        PODZOL,
        ALFISOL,
        MOLLISOL;

        private static final Variant[] VALUES;

        public static Variant valueOf(int i) {
            return i >= 0 && i < VALUES.length ? VALUES[i] : ENTISOL;
        }

        @Override
        public Supplier<? extends Block> getBlock(SoilBlockType type) {
            return TFCBlocks.SOIL.get((Object)type).get(this);
        }

        public TFCItems.ItemId mudBrick() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> TFCItems.ENTISOL_MUD_BRICK;
                case 1 -> TFCItems.ARIDISOL_MUD_BRICK;
                case 2 -> TFCItems.OXISOL_MUD_BRICK;
                case 3 -> TFCItems.FLUVISOL_MUD_BRICK;
                case 4 -> TFCItems.ANDISOL_MUD_BRICK;
                case 5 -> TFCItems.PODZOL_MUD_BRICK;
                case 6 -> TFCItems.ALFISOL_MUD_BRICK;
                case 7 -> TFCItems.MOLLISOL_MUD_BRICK;
            };
        }

        static {
            VALUES = Variant.values();
        }
    }
}

