/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import com.mojang.serialization.MapCodec;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.container.ScribingTableContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScribingTableBlock
extends HorizontalDirectionalBlock
implements IForgeBlockExtension {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"tfc.screen.scribing_table");
    private static final VoxelShape BASE_SHAPE = Shapes.or((VoxelShape)ScribingTableBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ScribingTableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)12.0, (double)4.0), ScribingTableBlock.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), ScribingTableBlock.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), ScribingTableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0, (double)15.0)});
    private static final VoxelShape SHAPE_NS = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{ScribingTableBlock.box((double)12.0, (double)5.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0), ScribingTableBlock.box((double)2.0, (double)5.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0)});
    private static final VoxelShape SHAPE_EW = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{ScribingTableBlock.box((double)4.0, (double)5.0, (double)12.0, (double)12.0, (double)12.0, (double)14.0), ScribingTableBlock.box((double)4.0, (double)5.0, (double)2.0, (double)12.0, (double)12.0, (double)4.0)});
    private final ExtendedProperties properties;

    public ScribingTableBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.properties = properties;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH, Direction.SOUTH -> SHAPE_NS;
            case Direction.EAST, Direction.WEST -> SHAPE_EW;
            default -> BASE_SHAPE;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            player.openMenu(state.getMenuProvider(level, pos));
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((windowId, inv, player) -> new ScribingTableContainer(inv, windowId, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return this.fakeBlockCodec();
    }
}

