/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.Supplier;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.overworld.SolarCalculator;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.ISlowEntities;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.wood.FallenLeavesBlock;
import net.dries007.tfc.common.blocks.wood.ILeavesBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.Season;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCLeavesBlock
extends Block
implements ILeavesBlock,
IForgeBlockExtension,
IFluidLoggable,
ISlowEntities {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    public static final IntegerProperty DISTANCE = TFCBlockStateProperties.DISTANCE_10;
    public static final int MAX_DECAY_DISTANCE = 9;
    private final ExtendedProperties properties;
    private final int autumnIndex;
    @Nullable
    private final Supplier<? extends Block> fallenLeaves;
    @Nullable
    private final Supplier<? extends Block> fallenTwig;

    public static void doParticles(ServerLevel level, double x, double y, double z, int count) {
        level.sendParticles((ParticleOptions)((SimpleParticleType)TFCParticles.LEAF.get()), x, y, z, count, 0.0, 0.0, 0.0, (double)0.3f);
    }

    public static void onEntityInside(Level level, Entity entity) {
        if (Helpers.isEntity(entity, TFCTags.Entities.DESTROYED_BY_LEAVES)) {
            entity.kill();
        }
        if (level.random.nextInt(20) == 0 && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (Helpers.hasMoved(entity)) {
                TFCLeavesBlock.doParticles(server, entity.getX(), entity.getEyeY() - 0.25, entity.getZ(), 3);
            }
        }
    }

    public static void dripRainwater(Level level, BlockPos pos, RandomSource random) {
        BlockPos belowPos;
        BlockState belowState;
        if (!(!level.isRainingAt(pos.above()) || random.nextInt(15) != 1 || (belowState = level.getBlockState(belowPos = pos.below())).canOcclude() && belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP))) {
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)ParticleTypes.DRIPPING_WATER);
        }
    }

    public TFCLeavesBlock(ExtendedProperties properties, int autumnIndex, @Nullable Supplier<? extends Block> fallenLeaves, @Nullable Supplier<? extends Block> fallenTwig) {
        super(properties.properties());
        this.properties = properties;
        this.fallenLeaves = fallenLeaves;
        this.fallenTwig = fallenTwig;
        this.autumnIndex = autumnIndex;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(1))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        int distance = this.getDistance(facingState) + 1;
        if (distance != 1 || (Integer)state.getValue((Property)DISTANCE) != distance) {
            level.scheduleTick(currentPos, (Block)this, 1);
        }
        return state;
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return 1;
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 0.2f;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState belowState;
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && random.nextInt(30) == 0 && (Calendars.CLIENT.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, level)).getSeason() == Season.FALL || ClimateRenderCache.INSTANCE.getWind().lengthSquared() > 0.17639999f) && (belowState = level.getBlockState(pos.below())).isAir()) {
            BlockState aboveState = level.getBlockState(pos.above());
            Object particle = Helpers.isBlock(aboveState, (TagKey<Block>)BlockTags.SNOW) && random.nextBoolean() ? (ParticleOptions)TFCParticles.SNOWFLAKE.get() : new BlockParticleOption((ParticleType)TFCParticles.FALLING_LEAF.get(), state);
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)particle);
        }
        TFCLeavesBlock.dripRainwater(level, pos, random);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        super.randomTick(state, level, pos, rand);
        if ((Integer)state.getValue((Property)DISTANCE) > 9 && !((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            level.removeBlock(pos, false);
            if (rand.nextFloat() < 0.01f) {
                this.createDestructionEffects(state, level, pos, rand, false);
            }
            TFCLeavesBlock.doParticles(level, (float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat(), 1);
        } else if (rand.nextFloat() < 5.0E-4f && Calendars.SERVER.getHemispheralCalendarMonthOfYear(SolarCalculator.getInNorthernHemisphere(pos, (Level)level)).getSeason() == Season.FALL && !((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
            this.createDestructionEffects(state, level, pos, rand, true);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int oldDistance = (Integer)state.getValue((Property)DISTANCE);
        int distance = this.updateDistance((LevelAccessor)level, pos);
        if (distance > 9) {
            if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue()) {
                if (!TFCConfig.SERVER.enableLeavesDecaySlowly.get().booleanValue()) {
                    level.removeBlock(pos, false);
                    if (rand.nextFloat() < 0.01f) {
                        this.createDestructionEffects(state, level, pos, rand, false);
                    }
                    TFCLeavesBlock.doParticles(level, (float)pos.getX() + rand.nextFloat(), (float)pos.getY() + rand.nextFloat(), (float)pos.getZ() + rand.nextFloat(), 1);
                } else {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(10)));
                }
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(9)), 3);
            }
        } else if (distance != oldDistance) {
            level.setBlock(pos, (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(distance)), 3);
        }
    }

    public void createDestructionEffects(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, boolean replaceOnlyAir) {
        BlockState twig = this.getFallenTwig();
        BlockState leaf = this.getFallenLeaves();
        if (twig == null && leaf == null) {
            return;
        }
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        cursor.set((Vec3i)pos);
        BlockState stateAt = Blocks.AIR.defaultBlockState();
        for (int i = 0; i < 15 && (stateAt.getBlock() instanceof ILeavesBlock || stateAt.canBeReplaced()); ++i) {
            cursor.move(0, -1, 0);
            stateAt = level.getBlockState((BlockPos)cursor);
        }
        cursor.move(0, 1, 0);
        stateAt = level.getBlockState((BlockPos)cursor);
        if (stateAt.canBeReplaced()) {
            BlockState placeState;
            BlockState blockState = placeState = twig == null ? leaf : twig;
            if (leaf != null && twig != null && random.nextFloat() < 0.5f) {
                Block block;
                placeState = leaf;
                if (stateAt.getBlock() == leaf.getBlock() && (block = stateAt.getBlock()) instanceof FallenLeavesBlock) {
                    FallenLeavesBlock leavesBlock = (FallenLeavesBlock)block;
                    if ((Integer)stateAt.getValue((Property)FallenLeavesBlock.LAYERS) < 8) {
                        int layers = (Integer)stateAt.getValue((Property)FallenLeavesBlock.LAYERS);
                        BlockState toPlace = layers + 1 == 8 ? (BlockState)leavesBlock.getLeaves().get().defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)) : (BlockState)state.setValue((Property)FallenLeavesBlock.LAYERS, (Comparable)Integer.valueOf(layers + 1));
                        level.setBlockAndUpdate(pos, toPlace);
                    }
                }
            }
            if (placeState.canSurvive((LevelReader)level, (BlockPos)cursor)) {
                if (replaceOnlyAir && !stateAt.isAir()) {
                    return;
                }
                level.setBlockAndUpdate((BlockPos)cursor, placeState);
            }
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        TFCLeavesBlock.onEntityInside(level, entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(context.getPlayer() != null))).setValue((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.getType()));
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PERSISTENT, DISTANCE, this.getFluidProperty()});
    }

    @Nullable
    public BlockState getFallenLeaves() {
        return this.fallenLeaves == null ? null : this.fallenLeaves.get().defaultBlockState();
    }

    @Nullable
    public BlockState getFallenTwig() {
        return this.fallenTwig == null ? null : this.fallenTwig.get().defaultBlockState();
    }

    @Override
    public float slowEntityFactor(BlockState state) {
        return state.getFluidState().isEmpty() ? TFCConfig.SERVER.leavesMovementModifier.get().floatValue() : 1.0f;
    }

    public int getAutumnIndex() {
        return this.autumnIndex;
    }

    private int updateDistance(LevelAccessor level, BlockPos pos) {
        int distance = 10;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : Helpers.DIRECTIONS) {
            mutablePos.set((Vec3i)pos).move(direction);
            distance = Math.min(distance, this.getDistance(level.getBlockState((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return distance;
    }

    private int getDistance(BlockState neighbor) {
        if (Helpers.isBlock(neighbor.getBlock(), (TagKey<Block>)BlockTags.LOGS)) {
            return 0;
        }
        return neighbor.getBlock() == this ? (Integer)neighbor.getValue((Property)DISTANCE) : 9;
    }
}

