/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.wood;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.items.PlantableInfo;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TFCSaplingBlock
extends SaplingBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;
    private final Supplier<Integer> ticksToGrow;
    private final boolean sand;

    public TFCSaplingBlock(TreeGrower tree, ExtendedProperties properties, Supplier<Integer> ticksToGrow, boolean sand) {
        super(tree, properties.properties());
        this.properties = properties;
        this.ticksToGrow = ticksToGrow;
        this.sand = sand;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && random.nextInt(7) == 0) {
            TickCounterBlockEntity counter;
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TickCounterBlockEntity && (counter = (TickCounterBlockEntity)blockEntity).getTicksSinceUpdate() > this.getTicksToGrow()) {
                this.advanceTree(level, pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(1)), random);
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        if (this.sand && Helpers.isBlock(state, (TagKey<Block>)BlockTags.SAND)) {
            return true;
        }
        return super.mayPlaceOn(state, level, pos) || Helpers.isBlock(state.getBlock(), TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public final long getTicksToGrow() {
        return (long)((double)this.ticksToGrow.get().intValue() * TFCConfig.SERVER.saplingGrowthModifier.get());
    }

    public static class TFCSaplingBlockItem
    extends BlockItem
    implements PlantableInfo {
        private final LongSupplier growthTicks;

        public TFCSaplingBlockItem(Block block, Item.Properties properties) {
            super(block, properties);
            if (block instanceof TFCSaplingBlock) {
                TFCSaplingBlock sapling = (TFCSaplingBlock)block;
                this.growthTicks = sapling::getTicksToGrow;
            } else {
                this.growthTicks = () -> -1L;
            }
        }

        @Override
        public int getGrowthTimeInfo() {
            return (int)this.growthTicks.getAsLong();
        }
    }
}

