/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.Arrays;
import java.util.stream.Stream;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.component.block.Barrel;
import net.dries007.tfc.common.component.fluid.FluidContainerHandler;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.component.mold.IMold;
import net.dries007.tfc.common.component.mold.Mold;
import net.dries007.tfc.common.component.mold.Vessel;
import net.dries007.tfc.common.items.FluidContainerItem;
import net.dries007.tfc.common.items.LampBlockItem;
import net.dries007.tfc.common.items.MoldItem;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.common.items.VesselItem;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public final class ItemCapabilities {
    public static final ItemCapability<IHeat, @Nullable Void> HEAT = ItemCapability.createVoid((ResourceLocation)Helpers.identifier("heat"), IHeat.class);
    public static final ItemCapability<IMold, @Nullable Void> MOLD = ItemCapability.createVoid((ResourceLocation)Helpers.identifier("mold"), IMold.class);
    public static final ItemCapability<IFluidHandlerItem, @Nullable Void> FLUID = Capabilities.FluidHandler.ITEM;
    public static final ItemCapability<IItemHandler, @Nullable Void> ITEM = Capabilities.ItemHandler.ITEM;

    public static void register(RegisterCapabilitiesEvent event) {
        ItemLike[] molds = (ItemLike[])Stream.concat(TFCItems.MOLDS.values().stream(), Stream.of(TFCItems.BELL_MOLD, TFCItems.FIRE_INGOT_MOLD)).toArray(ItemLike[]::new);
        event.registerItem(MOLD, ItemCapabilities::forMold, molds);
        event.registerItem(HEAT, ItemCapabilities::forMold, molds);
        event.registerItem(FLUID, ItemCapabilities::forMold, molds);
        ItemLike[] vessels = (ItemLike[])Stream.concat(TFCItems.GLAZED_VESSELS.values().stream(), Stream.of(TFCItems.VESSEL)).toArray(ItemLike[]::new);
        event.registerItem(MOLD, ItemCapabilities::forVessel, vessels);
        event.registerItem(HEAT, ItemCapabilities::forVessel, vessels);
        event.registerItem(FLUID, ItemCapabilities::forVessel, vessels);
        event.registerItem(ITEM, ItemCapabilities::forVessel, vessels);
        ItemLike[] barrels = (ItemLike[])TFCBlocks.WOODS.values().stream().map(m -> ((TFCBlocks.Id)m.get((Object)Wood.BlockType.BARREL)).asItem()).toArray(ItemLike[]::new);
        event.registerItem(FLUID, (stack, context) -> new Barrel((ItemStack)stack), barrels);
        ItemLike[] lamps = (ItemLike[])Arrays.stream(Metal.values()).filter(m -> Metal.BlockType.LAMP.has((Metal)m)).map(m -> TFCBlocks.METALS.get(m).get((Object)Metal.BlockType.LAMP)).toArray(ItemLike[]::new);
        event.registerItem(FLUID, ItemCapabilities::forLamp, lamps);
        event.registerItem(FLUID, ItemCapabilities::forBucket, new ItemLike[]{TFCItems.JUG, TFCItems.WOODEN_BUCKET, TFCItems.RED_STEEL_BUCKET, TFCItems.BLUE_STEEL_BUCKET, TFCItems.HEMATITIC_GLASS_BOTTLE, TFCItems.OLIVINE_GLASS_BOTTLE, TFCItems.SILICA_GLASS_BOTTLE, TFCItems.VOLCANIC_GLASS_BOTTLE});
    }

    @Nullable
    public static IMold forMold(ItemStack stack, @Nullable Void context) {
        Mold mold;
        Item item = stack.getItem();
        if (item instanceof MoldItem) {
            MoldItem item2 = (MoldItem)item;
            mold = new Mold(stack, item2.containerInfo());
        } else {
            mold = null;
        }
        return mold;
    }

    @Nullable
    public static Vessel forVessel(ItemStack stack, @Nullable Void context) {
        Vessel vessel;
        Item item = stack.getItem();
        if (item instanceof VesselItem) {
            VesselItem item2 = (VesselItem)item;
            vessel = new Vessel(stack, item2.containerInfo());
        } else {
            vessel = null;
        }
        return vessel;
    }

    @Nullable
    public static FluidContainerHandler forLamp(ItemStack stack, @Nullable Void context) {
        FluidContainerHandler fluidContainerHandler;
        Item item = stack.getItem();
        if (item instanceof LampBlockItem) {
            LampBlockItem item2 = (LampBlockItem)item;
            fluidContainerHandler = new FluidContainerHandler(stack, item2.containerInfo());
        } else {
            fluidContainerHandler = null;
        }
        return fluidContainerHandler;
    }

    @Nullable
    public static FluidContainerHandler forBucket(ItemStack stack, @Nullable Void context) {
        FluidContainerHandler fluidContainerHandler;
        Item item = stack.getItem();
        if (item instanceof FluidContainerItem) {
            FluidContainerItem item2 = (FluidContainerItem)item;
            fluidContainerHandler = new FluidContainerHandler(stack, item2.containerInfo());
        } else {
            fluidContainerHandler = null;
        }
        return fluidContainerHandler;
    }
}

