/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.capabilities;

import java.util.function.Function;
import java.util.function.Predicate;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class SidedHandler<T> {
    private static final int SIDES = Direction.values().length;
    private final T internal;
    @Nullable
    private final T[] sides;

    public SidedHandler(T internal) {
        this.internal = internal;
        this.sides = new Object[SIDES];
    }

    @Nullable
    public T get(@Nullable Direction side) {
        return side == null ? this.internal : this.sides[side.ordinal()];
    }

    public SidedHandler<T> on(Function<T, ? extends T> wrap, Predicate<Direction> sides) {
        return this.on(wrap.apply(this.internal), sides);
    }

    public SidedHandler<T> on(T handler, Predicate<Direction> sides) {
        for (Direction side : Helpers.DIRECTIONS) {
            if (!sides.test(side)) continue;
            this.sides[side.ordinal()] = handler;
        }
        return this;
    }

    public SidedHandler<T> on(Function<T, ? extends T> wrap, Direction ... sides) {
        return this.on(wrap.apply(this.internal), sides);
    }

    public SidedHandler<T> on(T handler, Direction ... sides) {
        for (Direction side : sides) {
            this.sides[side.ordinal()] = handler;
        }
        return this;
    }
}

