/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dries007.tfc.common.component.food.Nutrient;
import net.dries007.tfc.common.player.IPlayerInfo;
import net.dries007.tfc.util.Helpers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public final class PlayerCommand {
    private static final String QUERY_HUNGER = "tfc.commands.player.query_hunger";
    private static final String QUERY_SATURATION = "tfc.commands.player.query_saturation";
    private static final String QUERY_WATER = "tfc.commands.player.query_water";
    private static final String QUERY_NUTRITION = "tfc.commands.player.query_nutrition";
    private static final String FAIL_INVALID_FOOD_STATS = "tfc.commands.player.fail_invalid_food_stats";

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").then(Commands.literal((String)"hunger").executes(context -> PlayerCommand.queryHunger((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"saturation").executes(context -> PlayerCommand.querySaturation((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"water").executes(context -> PlayerCommand.queryWater((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"nutrition").executes(context -> PlayerCommand.queryNutrition((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"hunger").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.setHunger((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false))))).then(Commands.literal((String)"saturation").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false))))).then(Commands.literal((String)"water").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PlayerCommand.setWater((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.literal((String)"hunger").executes(context -> PlayerCommand.setHunger((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), 20, false)))).then(Commands.literal((String)"saturation").executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), 5, false)))).then(Commands.literal((String)"water").executes(context -> PlayerCommand.setWater((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), 100, false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"hunger").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(context -> PlayerCommand.setHunger((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))).then(Commands.literal((String)"saturation").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-20, (int)20)).executes(context -> PlayerCommand.setSaturation((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))).then(Commands.literal((String)"water").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> PlayerCommand.setWater((Player)EntityArgument.getPlayer((CommandContext)context, (String)"target"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), true))))));
    }

    private static int queryHunger(CommandContext<CommandSourceStack> context, Player player) {
        int hunger = player.getFoodData().getFoodLevel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)QUERY_HUNGER, (Object[])new Object[]{hunger}), true);
        return 1;
    }

    private static int querySaturation(CommandContext<CommandSourceStack> context, Player player) {
        float saturation = player.getFoodData().getSaturationLevel();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)QUERY_SATURATION, (Object[])new Object[]{Float.valueOf(saturation)}), true);
        return 1;
    }

    private static int queryWater(CommandContext<CommandSourceStack> context, Player player) {
        float water = IPlayerInfo.get(player).getThirst();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)QUERY_WATER, (Object[])new Object[]{Float.valueOf(water)}), true);
        return 1;
    }

    private static int queryNutrition(CommandContext<CommandSourceStack> context, Player player) {
        float[] nutrition = IPlayerInfo.get(player).nutrition().getNutrients();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)QUERY_NUTRITION), true);
        for (Nutrient nutrient : Nutrient.VALUES) {
            int percent = (int)(100.0f * nutrition[nutrient.ordinal()]);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)" - ").append((Component)Helpers.translateEnum(nutrient).withStyle(nutrient.getColor())).append(": " + percent + "%"), true);
        }
        return 1;
    }

    private static int setHunger(Player player, int hunger, boolean add) {
        if (add) {
            hunger += player.getFoodData().getFoodLevel();
        }
        player.getFoodData().setFoodLevel(hunger);
        return 1;
    }

    private static int setSaturation(Player player, int saturation, boolean add) {
        if (add) {
            saturation = (int)((float)saturation + player.getFoodData().getSaturationLevel());
        }
        player.getFoodData().setSaturation((float)saturation);
        return 1;
    }

    private static int setWater(Player player, int water, boolean add) {
        IPlayerInfo info = IPlayerInfo.get(player);
        if (add) {
            water = (int)((float)water + info.getThirst());
        }
        info.setThirst(water);
        return 1;
    }
}

