/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component;

import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodComponent;
import net.dries007.tfc.common.component.food.FoodDefinition;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.HeatComponent;
import net.dries007.tfc.mixin.accessor.PatchedDataComponentMapAccessor;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ItemStackHooks {
    static boolean ENABLED = false;

    public static void onModifyItemStackComponents(ItemStack stack) {
        Record def;
        if (TFCComponents.HEAT.holder().isBound()) {
            @Nullable HeatComponent heat = (HeatComponent)stack.get(TFCComponents.HEAT);
            if (heat != null) {
                heat.capture(stack);
            } else {
                def = HeatCapability.getDefinition(stack);
                if (def != null) {
                    stack.set(TFCComponents.HEAT, (Object)HeatComponent.of(def));
                }
            }
        }
        if (TFCComponents.FOOD.holder().isBound()) {
            @Nullable FoodComponent food = (FoodComponent)stack.get(TFCComponents.FOOD);
            if (food != null) {
                food.capture(stack);
            } else {
                def = FoodCapability.getDefinition(stack);
                if (def != null) {
                    stack.set(TFCComponents.FOOD, (Object)new FoodComponent((FoodDefinition)def));
                }
            }
        }
    }

    public static PatchedDataComponentMap onCopyItemStackComponents(ItemStack stack, PatchedDataComponentMap map) {
        DataComponentMap newPrototype;
        DataComponentMap prevPrototype = ((PatchedDataComponentMapAccessor)map).accessor$getPrototype();
        if (prevPrototype == (newPrototype = stack.getItem().components())) {
            return map.copy();
        }
        return PatchedDataComponentMap.fromPatch((DataComponentMap)newPrototype, (DataComponentPatch)map.asPatch());
    }
}

