/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.fluid;

import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public interface FluidContainer
extends IFluidHandler {
    public FluidContainerInfo containerInfo();

    default public int getTanks() {
        return 1;
    }

    default public int getTankCapacity(int tank) {
        return this.containerInfo().fluidCapacity();
    }

    default public boolean isFluidValid(int tank, FluidStack stack) {
        return this.containerInfo().canContainFluid(stack);
    }

    default public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.getFluidInTank(0))) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }
}

