/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.fluid;

import net.dries007.tfc.common.component.ComponentView;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.fluid.FluidComponent;
import net.dries007.tfc.common.component.fluid.FluidContainer;
import net.dries007.tfc.common.component.fluid.FluidContainerInfo;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidContainerHandler
extends ComponentView<FluidComponent>
implements IFluidHandlerItem,
FluidContainer {
    private final FluidContainerInfo containerInfo;

    public FluidContainerHandler(ItemStack stack, FluidContainerInfo containerInfo) {
        super(stack, TFCComponents.FLUID, FluidComponent.EMPTY);
        this.containerInfo = containerInfo;
    }

    @Override
    public FluidContainerInfo containerInfo() {
        return this.containerInfo;
    }

    public ItemStack getContainer() {
        return this.stack;
    }

    public FluidStack getFluidInTank(int tank) {
        return ((FluidComponent)this.component).content();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidComponent.FillInfo remainder = FluidComponent.fill(((FluidComponent)this.component).content(), resource, this.containerInfo);
        if (action.execute()) {
            this.apply(new FluidComponent(remainder.content()));
        }
        return remainder.filled();
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidComponent.DrainInfo remainder = FluidComponent.drain(((FluidComponent)this.component).content(), maxDrain);
        if (action.execute()) {
            this.apply(new FluidComponent(remainder.content()));
        }
        return remainder.drained();
    }
}

