/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.forge.ForgingBonus;
import net.dries007.tfc.util.tooltip.Tooltips;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record ForgingBonusComponent(ForgingBonus type, Optional<String> author) {
    public static final Codec<ForgingBonusComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)ForgingBonus.CODEC.fieldOf("type").forGetter(c -> c.type), (App)Codec.sizeLimitedString((int)32).optionalFieldOf("author").forGetter(c -> c.author)).apply((Applicative)i, ForgingBonusComponent::new));
    public static final StreamCodec<ByteBuf, ForgingBonusComponent> STREAM_CODEC = StreamCodec.composite(ForgingBonus.STREAM_CODEC, c -> c.type, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.stringUtf8((int)32)), c -> c.author, ForgingBonusComponent::new);
    private static final ForgingBonusComponent EMPTY = new ForgingBonusComponent(ForgingBonus.NONE, Optional.empty());

    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        @Nullable ForgingBonusComponent component = (ForgingBonusComponent)stack.get(TFCComponents.FORGING_BONUS);
        if (component != null && component.type != ForgingBonus.NONE) {
            MutableComponent name = component.type.getDisplayName();
            tooltips.add((Component)component.author.map(author -> Tooltips.author((Component)name, author)).orElse(name));
        }
    }

    public static int applyLikeUnbreaking(ItemStack stack, RandomSource random, int originalDamage) {
        ForgingBonus bonus = ForgingBonusComponent.get(stack);
        int damage = originalDamage;
        if (bonus != ForgingBonus.NONE) {
            for (int i = 0; i < damage; ++i) {
                if (!(random.nextFloat() < bonus.durability())) continue;
                --damage;
            }
        }
        return damage;
    }

    public static ItemStack copy(ItemStack from, ItemStack to) {
        ForgingBonusComponent component = (ForgingBonusComponent)from.get(TFCComponents.FORGING_BONUS);
        if (component != null) {
            to.set(TFCComponents.FORGING_BONUS, (Object)component);
        }
        return to;
    }

    public static ForgingBonus get(ItemStack stack) {
        return ((ForgingBonusComponent)stack.getOrDefault(TFCComponents.FORGING_BONUS, (Object)ForgingBonusComponent.EMPTY)).type;
    }

    public static void set(ItemStack stack, ForgingBonus bonus) {
        ForgingBonusComponent.set(stack, bonus, null);
    }

    public static void set(ItemStack stack, ForgingBonus bonus, @Nullable Player player) {
        if (bonus != ForgingBonus.NONE) {
            stack.set(TFCComponents.FORGING_BONUS, (Object)new ForgingBonusComponent(bonus, player == null ? Optional.empty() : Optional.of(player.getName().getString())));
        }
    }
}

