/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import net.dries007.tfc.common.component.forge.ForgeStep;
import net.dries007.tfc.common.component.forge.ForgeSteps;
import net.dries007.tfc.common.recipes.AnvilRecipe;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public final class ForgingComponent {
    public static final Codec<ForgingComponent> CODEC = RecordCodecBuilder.create(i -> i.group((App)ForgeSteps.CODEC.optionalFieldOf("steps", (Object)ForgeSteps.EMPTY).forGetter(c -> c.steps), (App)Codec.INT.optionalFieldOf("work", (Object)0).forGetter(c -> c.work), (App)Codec.INT.optionalFieldOf("target", (Object)0).forGetter(c -> c.target), (App)ResourceLocation.CODEC.optionalFieldOf("recipe").forGetter(c -> Optional.ofNullable(c.recipeId))).apply((Applicative)i, ForgingComponent::new));
    public static final StreamCodec<ByteBuf, ForgingComponent> STREAM_CODEC = StreamCodec.composite(ForgeSteps.STREAM_CODEC, c -> c.steps, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.work, (StreamCodec)ByteBufCodecs.VAR_INT, c -> c.target, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> Optional.ofNullable(c.recipeId), ForgingComponent::new);
    public static final ForgingComponent EMPTY = new ForgingComponent(ForgeSteps.EMPTY, 0, 0, Optional.empty());
    final ForgeSteps steps;
    final int work;
    final int target;
    @Nullable
    private ResourceLocation recipeId;
    @Nullable
    private AnvilRecipe recipe;

    ForgingComponent(ForgeSteps steps, int work, int target, Optional<ResourceLocation> recipeId) {
        this(steps, work, target, recipeId.orElse(null), null);
    }

    ForgingComponent(ForgeSteps steps, int work, int target, @Nullable ResourceLocation recipeId, @Nullable AnvilRecipe recipe) {
        this.steps = steps;
        this.work = work;
        this.target = target;
        this.recipeId = recipeId;
        this.recipe = recipe;
    }

    @Nullable
    AnvilRecipe getRecipe() {
        if (this.recipeId != null && this.recipe == null) {
            this.recipe = AnvilRecipe.byId(this.recipeId);
            if (this.recipe == null) {
                this.recipeId = null;
            }
        }
        return this.recipe;
    }

    ForgingComponent withRecipe(@Nullable RecipeHolder<AnvilRecipe> recipe, int target) {
        return recipe == null ? new ForgingComponent(this.steps, this.work, -1, null, null) : new ForgingComponent(this.steps, this.work, target, recipe.id(), (AnvilRecipe)recipe.value());
    }

    ForgingComponent withStep(ForgeStep step, int amount) {
        return new ForgingComponent(this.steps.withStep(step), this.work + amount, this.target, this.recipeId, this.recipe);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof ForgingComponent)) return false;
        ForgingComponent that = (ForgingComponent)obj;
        if (!this.steps.equals(that.steps)) return false;
        if (this.work != that.work) return false;
        if (this.target != that.target) return false;
        if (!Objects.equals(this.recipeId, that.recipeId)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.steps, this.work, this.target, this.recipeId);
    }

    public String toString() {
        return "ForgingComponent[steps=" + String.valueOf(this.steps) + ", work=" + this.work + ", target=" + this.target + ", recipe=" + String.valueOf(this.recipeId) + "]";
    }
}

