/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.glass;

import com.google.common.base.Suppliers;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.component.glass.IGlassworkingTool;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.Nullable;

public class GlassOperation {
    public static final ResourceKey<Registry<GlassOperation>> KEY = ResourceKey.createRegistryKey((ResourceLocation)Helpers.identifier("glass_operation"));
    public static final Registry<GlassOperation> REGISTRY = new RegistryBuilder(KEY).sync(true).create();
    public static final DeferredRegister<GlassOperation> OPERATIONS = DeferredRegister.create(KEY, (String)"tfc");
    public static final Supplier<Map<Item, GlassOperation>> POWDERS = Suppliers.memoize(() -> {
        IdentityHashMap map = new IdentityHashMap();
        REGISTRY.stream().filter(op -> op.powder).forEach(op -> {
            for (Holder<Item> item : op.items) {
                map.put((Item)item.value(), op);
            }
        });
        return map;
    });
    public static final DeferredHolder<GlassOperation, GlassOperation> BLOW = OPERATIONS.register("blow", () -> new GlassOperation((Set<Holder<Item>>)Set.of(TFCItems.BLOWPIPE_WITH_GLASS.holder(), TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.holder()), (Holder<SoundEvent>)TFCSounds.BELLOWS_BLOW.holder(), Heat.FAINT_RED.getMin(), false));
    public static final DeferredHolder<GlassOperation, GlassOperation> ROLL = GlassOperation.register("roll", TFCItems.WOOL_CLOTH);
    public static final DeferredHolder<GlassOperation, GlassOperation> STRETCH = GlassOperation.register("stretch", Set.of(TFCItems.BLOWPIPE_WITH_GLASS.holder(), TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.holder()));
    public static final DeferredHolder<GlassOperation, GlassOperation> PINCH = GlassOperation.register("pinch", TFCItems.JACKS);
    public static final DeferredHolder<GlassOperation, GlassOperation> FLATTEN = GlassOperation.register("flatten", TFCItems.PADDLE);
    public static final DeferredHolder<GlassOperation, GlassOperation> SAW = OPERATIONS.register("saw", () -> new GlassOperation(Set.of(TFCItems.GEM_SAW.holder()), (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.ANVIL_USE), 0.0f, false));
    public static final DeferredHolder<GlassOperation, GlassOperation> AMETHYST = GlassOperation.powder("amethyst", TFCItems.ORE_POWDERS.get((Object)Ore.AMETHYST));
    public static final DeferredHolder<GlassOperation, GlassOperation> SODA_ASH = GlassOperation.powder("soda_ash", TFCItems.POWDERS.get((Object)Powder.SODA_ASH));
    public static final DeferredHolder<GlassOperation, GlassOperation> SULFUR = GlassOperation.powder("sulfur", TFCItems.ORE_POWDERS.get((Object)Ore.SULFUR));
    public static final DeferredHolder<GlassOperation, GlassOperation> IRON = GlassOperation.powder("iron", Set.of(TFCItems.ORE_POWDERS.get((Object)Ore.HEMATITE).holder(), TFCItems.ORE_POWDERS.get((Object)Ore.LIMONITE).holder(), TFCItems.ORE_POWDERS.get((Object)Ore.MAGNETITE).holder()));
    public static final DeferredHolder<GlassOperation, GlassOperation> RUBY = GlassOperation.powder("ruby", TFCItems.ORE_POWDERS.get((Object)Ore.RUBY));
    public static final DeferredHolder<GlassOperation, GlassOperation> LAPIS_LAZULI = GlassOperation.powder("lapis_lazuli", TFCItems.ORE_POWDERS.get((Object)Ore.LAPIS_LAZULI));
    public static final DeferredHolder<GlassOperation, GlassOperation> PYRITE = GlassOperation.powder("pyrite", TFCItems.ORE_POWDERS.get((Object)Ore.PYRITE));
    public static final DeferredHolder<GlassOperation, GlassOperation> SAPPHIRE = GlassOperation.powder("sapphire", TFCItems.ORE_POWDERS.get((Object)Ore.SAPPHIRE));
    public static final DeferredHolder<GlassOperation, GlassOperation> GOLD = GlassOperation.powder("gold", TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_GOLD));
    public static final DeferredHolder<GlassOperation, GlassOperation> GRAPHITE = GlassOperation.powder("graphite", TFCItems.ORE_POWDERS.get((Object)Ore.GRAPHITE));
    public static final DeferredHolder<GlassOperation, GlassOperation> COPPER = GlassOperation.powder("copper", Set.of(TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_COPPER).holder(), TFCItems.ORE_POWDERS.get((Object)Ore.MALACHITE).holder(), TFCItems.ORE_POWDERS.get((Object)Ore.TETRAHEDRITE).holder()));
    public static final DeferredHolder<GlassOperation, GlassOperation> NICKEL = GlassOperation.powder("nickel", TFCItems.ORE_POWDERS.get((Object)Ore.GARNIERITE));
    public static final DeferredHolder<GlassOperation, GlassOperation> TIN = GlassOperation.powder("tin", TFCItems.ORE_POWDERS.get((Object)Ore.CASSITERITE));
    public static final DeferredHolder<GlassOperation, GlassOperation> SILVER = GlassOperation.powder("silver", TFCItems.ORE_POWDERS.get((Object)Ore.NATIVE_SILVER));
    public static final DeferredHolder<GlassOperation, GlassOperation> TABLE_POUR = GlassOperation.register("table_pour", Set.of(TFCItems.BLOWPIPE_WITH_GLASS.holder(), TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.holder()));
    public static final DeferredHolder<GlassOperation, GlassOperation> BASIN_POUR = GlassOperation.register("basin_pour", Set.of(TFCItems.BLOWPIPE_WITH_GLASS.holder(), TFCItems.CERAMIC_BLOWPIPE_WITH_GLASS.holder()));
    private final Set<Holder<Item>> items;
    private final Holder<SoundEvent> sound;
    private final float minTemperature;
    private final boolean powder;
    @Nullable
    private String translationId;

    @Nullable
    public static GlassOperation get(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return (GlassOperation)(player.getLookAngle().y < -0.95 ? STRETCH : BLOW).get();
        }
        Item item = stack.getItem();
        if (item instanceof IGlassworkingTool) {
            IGlassworkingTool tool = (IGlassworkingTool)item;
            return tool.getOperation();
        }
        return null;
    }

    @Nullable
    public static GlassOperation getByPowder(ItemStack stack) {
        return POWDERS.get().get(stack.getItem());
    }

    public GlassOperation(Holder<Item> item, boolean isPowder) {
        this(Set.of(item), (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.ANVIL_USE), Heat.FAINT_RED.getMin(), isPowder);
    }

    public GlassOperation(Set<Holder<Item>> items, Holder<SoundEvent> sound, float minTemperature, boolean isPowder) {
        this.items = items;
        this.sound = sound;
        this.minTemperature = minTemperature;
        this.powder = isPowder;
    }

    public String getTranslationId() {
        if (this.translationId == null) {
            this.translationId = Util.makeDescriptionId((String)"glass_operation", (ResourceLocation)REGISTRY.getKey((Object)this));
        }
        return this.translationId;
    }

    public Set<Holder<Item>> getItems() {
        return this.items;
    }

    public SoundEvent getSound() {
        return (SoundEvent)this.sound.value();
    }

    public boolean hasRequiredTemperature(ItemStack stack) {
        return HeatCapability.getTemperature(stack) > this.minTemperature;
    }

    private static DeferredHolder<GlassOperation, GlassOperation> powder(String name, TFCItems.ItemId item) {
        return OPERATIONS.register(name, () -> new GlassOperation((Holder<Item>)item.holder(), true));
    }

    private static DeferredHolder<GlassOperation, GlassOperation> powder(String name, Set<Holder<Item>> items) {
        return OPERATIONS.register(name, () -> new GlassOperation(items, (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.ANVIL_USE), Heat.FAINT_RED.getMin(), true));
    }

    private static DeferredHolder<GlassOperation, GlassOperation> register(String name, Set<Holder<Item>> items) {
        return OPERATIONS.register(name, () -> new GlassOperation(items, (Holder<SoundEvent>)Holder.direct((Object)SoundEvents.ANVIL_USE), Heat.FAINT_RED.getMin(), false));
    }

    private static DeferredHolder<GlassOperation, GlassOperation> register(String name, TFCItems.ItemId item) {
        return OPERATIONS.register(name, () -> new GlassOperation((Holder<Item>)item.holder(), false));
    }
}

