/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.glass;

import java.util.List;
import net.dries007.tfc.common.component.TFCComponents;
import net.dries007.tfc.common.component.glass.GlassOperation;
import net.dries007.tfc.common.component.glass.GlassOperations;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class GlassWorking {
    public static void addTooltipInfo(ItemStack stack, List<Component> tooltips) {
        GlassOperations data = GlassWorking.get(stack);
        if (!data.isEmpty()) {
            tooltips.add(data.batch().getHoverName());
            if (!data.steps().isEmpty()) {
                tooltips.add((Component)Component.translatable((String)"tfc.tooltip.glass.title").withStyle(ChatFormatting.AQUA));
                for (GlassOperation operation : data.steps()) {
                    tooltips.add((Component)Component.literal((String)"- ").append((Component)Component.translatable((String)operation.getTranslationId())));
                }
            }
        }
    }

    public static GlassOperations get(ItemStack stack) {
        return (GlassOperations)stack.getOrDefault(TFCComponents.GLASS, (Object)GlassOperations.DEFAULT);
    }

    public static void clear(ItemStack stack) {
        stack.set(TFCComponents.GLASS, (Object)GlassOperations.DEFAULT);
    }

    public static void apply(ItemStack stack, GlassOperation operation) {
        if (!stack.isEmpty()) {
            stack.set(TFCComponents.GLASS, (Object)GlassWorking.get(stack).with(operation));
        }
    }

    public static void createNewBatch(ItemStack stack, ItemStack glass) {
        if (!stack.isEmpty()) {
            stack.set(TFCComponents.GLASS, (Object)GlassWorking.get(stack).with(glass));
        }
    }
}

