/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.component.heat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.dries007.tfc.common.recipes.IRecipePredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record HeatDefinition(Ingredient ingredient, float heatCapacity, float forgingTemperature, float weldingTemperature) implements IRecipePredicate<ItemStack>
{
    public static final Codec<HeatDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(c -> c.ingredient), (App)Codec.FLOAT.fieldOf("heat_capacity").forGetter(c -> Float.valueOf(c.heatCapacity)), (App)Codec.FLOAT.optionalFieldOf("forging_temperature", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.forgingTemperature)), (App)Codec.FLOAT.optionalFieldOf("welding_temperature", (Object)Float.valueOf(0.0f)).forGetter(c -> Float.valueOf(c.weldingTemperature))).apply((Applicative)i, HeatDefinition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, HeatDefinition> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, c -> c.ingredient, (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.heatCapacity), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.forgingTemperature), (StreamCodec)ByteBufCodecs.FLOAT, c -> Float.valueOf(c.weldingTemperature), HeatDefinition::new);
    public static final HeatDefinition DEFAULT = new HeatDefinition(Ingredient.EMPTY, 0.0f, 0.0f, 0.0f);

    @Override
    public boolean matches(ItemStack input) {
        return this.ingredient.test(input);
    }
}

